<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact',
        'label' => 'contact',
        'label_alt' => 'organisation',
        'label_alt_force' => true,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'title',
        'iconfile' => 'EXT:igs_crm/Resources/Public/Icons/tx_igscrm_domain_model_contactcontact.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'active, start_date, end_date, title, acl, contact, organisation, relation_type, relation_function, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igscrm_domain_model_contactcontact',
                'foreign_table_where' => 'AND {#tx_igscrm_domain_model_contactcontact}.{#pid}=###CURRENT_PID### AND {#tx_igscrm_domain_model_contactcontact}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'active' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.active',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
            ]
        ],
        'start_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.start_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'end_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.end_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'default' => ''
            ],
        ],
        'acl' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.acl',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'Keine Berechtigungen', 'value' => 0],
                    ['label' => 'Firmendaten', 'value' => 1],
                    ['label' => 'Mitglieder', 'value' => 2],
                    ['label' => 'Administrator', 'value' => 3],
                ],
                'size' => 1,
                'maxitems' => 1,
                'eval' => ''
            ],
        ],
        'contact' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.contact',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_contact',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
            
        ],
        'organisation' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.organisation',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_contact',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
            
        ],
        'relation_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.relation_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_relationtype',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
            
        ],
        'relation_function' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contactcontact.relation_function',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_relationfunction',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
            
        ],
    
    ],
];
