<?php
$GLOBALS['TCA']['tx_igscrm_domain_model_kursteilnehmer'] = [
    'ctrl' => [
        'title'	=> 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer',
        'label' => 'kt_startdatum',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'dividers2tabs' => true,

        'versioningWS' => 2,
        'versioning_followPages' => true,

        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'kt_startdatum,kt_enddatum,kt_dauer,kt_person,kt_kurse,',
        'iconfile' => 'EXT:igs_crm/Resources/Public/Icons/tx_igscrm_domain_model_kursteilnehmer.gif'
    ],
    // 'interface' => [
    //     'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, kt_startdatum, kt_enddatum, kt_dauer, kt_person, kt_kurse, kt_kursmodule',
    // ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid;;;;1-1-1, l10n_parent, l10n_diffsource, hidden;;1, kt_startdatum, kt_enddatum, kt_dauer, kt_person, kt_kurse, kt_kursmodule, --div--;LLL:EXT:cms/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'palettes' => [
        '1' => ['showitem' => ''],
    ],
    'columns' => [

        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language']
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            //'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igscrm_domain_model_kursteilnehmer',
                'foreign_table_where' => 'AND tx_igscrm_domain_model_kursteilnehmer.pid=###CURRENT_PID### AND tx_igscrm_domain_model_kursteilnehmer.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ]
        ],

        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
            ],
        ],
        'starttime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
            ],
        ],
        'endtime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
            ],
        ],

        'kt_startdatum' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_startdatum',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'size' => 7,
                'eval' => 'date',
                'checkbox' => 0,
                'default' => '0000-00-00'
            ],
        ],
        'kt_enddatum' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_enddatum',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'size' => 7,
                'eval' => 'date',
                'checkbox' => 0,
                'default' => '0000-00-00'
            ],
        ],
        'kt_dauer' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_dauer',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'kt_person' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_person',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_contact',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'kt_kurse' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_kurse',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_kurse',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'kt_kursmodule' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_kursteilnehmer.kt_kursmodule',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igscrm_domain_model_kursmodule',
                'MM' => 'tx_igscrm_kursteilnehmer_kursmodule_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'wizards' => [
                    '_PADDING' => 1,
                    '_VERTICAL' => 1,
                    'edit' => [
                        'type' => 'popup',
                        'title' => 'Edit',
                        'module' => [
                          'name' => 'wizard_edit',
                        ],
                        //'script' => 'wizard_edit.php',
                        'icon' => 'edit2.gif',
                        'popup_onlyOpenIfSelected' => 1,
                        'JSopenParams' => 'height=350,width=580,status=0,menubar=0,scrollbars=1',
                        ],
                    'add' => [
                        'type' => 'script',
                        'title' => 'Create new',
                        'icon' => 'add.gif',
                        'params' => [
                            'table' => 'tx_igscrm_domain_model_kursmodule',
                            'pid' => '###CURRENT_PID###',
                            'setValue' => 'prepend'
                            ],
                        'module' => [
                          'name' => 'wizard_add',
                        ],
                        //'script' => 'wizard_add.php',
                    ],
                ],
            ],
        ],

    ],
];
