<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,code,betrag,invoicestext',
        'iconfile' => 'EXT:igs_crm/Resources/Public/Icons/tx_igscrm_domain_model_mitgliedschaft.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, code, limit_to_type, betrag, invoicestext, no_person, verband, preise, card, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            //'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igscrm_domain_model_mitgliedschaft',
                'foreign_table_where' => 'AND tx_igscrm_domain_model_mitgliedschaft.pid=###CURRENT_PID### AND tx_igscrm_domain_model_mitgliedschaft.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/Resources/Private/Language/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
            ],
        ],

        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'code' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.code',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'limit_to_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.limit_to_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [  'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contact.type.person', 'value' => 'Person' ],
                    [  'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_contact.type.organisation', 'value' => 'Organisation'],
                ],
                'nullable' => true,
            ],
        ],
        'betrag' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.betrag',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'betrag_is_total' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.betrag_is_total',
            'config' => [
                'type' => 'check',
                'default' => 0
            ],
        ],
        'invoicestext' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_preise.invoicestext',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 5,
                'eval' => 'trim',
            ]
        ],
        'no_person' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.no_person',
            'config' => [
                'type' => 'check',
                'default' => 0
            ],
        ],
        'verband' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.verband',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_verband',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'preise' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.preise',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igscrm_domain_model_preise',
                'foreign_field' => 'mitgliedschaften',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1
                ],
            ],
        ],
        'card' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_mitgliedschaft.card',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_card',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],

        
    ],
];
