CREATE TABLE fe_users (
       crm_settings_printer_margin_top int(11) DEFAULT '0' NOT NULL,
       crm_settings_custom_css text,
       crm_verband_uids text,
       crm_default_group int(11) DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_contact'
#
CREATE TABLE tx_igscrm_domain_model_contact (
        type varchar(255) DEFAULT '' NOT NULL,
        must_reviewed tinyint(1) unsigned DEFAULT '0',
        me_ok  int(11) DEFAULT '0',

	me_addressid int(11) DEFAULT '0',
	bfs_uid varchar(255) DEFAULT '' NOT NULL,

	me_languageid int(11) unsigned DEFAULT '0',
	fallback_language int(11) unsigned DEFAULT '0',

	extra_sorting int(11) unsigned DEFAULT 100,
	parent int(11) unsigned DEFAULT '0',

	me_companyname varchar(255) DEFAULT '',
        me_addon varchar(255) DEFAULT '',
        addon_intern varchar(255) DEFAULT '',

	me_anrede_id int(11) unsigned DEFAULT '0',
	me_titel varchar(255) DEFAULT '',
	me_lastname varchar(255) DEFAULT '',
	me_firstname varchar(255) DEFAULT '',

	me_shortname varchar(255) DEFAULT '',

	me_address varchar(255) DEFAULT '',
	me_address2 varchar(255) DEFAULT '',
	me_address3 varchar(255) DEFAULT '',
	me_pobox varchar(255) DEFAULT '',
	me_zip varchar(255) DEFAULT '',
	me_city varchar(255) DEFAULT '',
	me_kanton_id int(11) unsigned DEFAULT '0',	
	me_country_abrev varchar(255) DEFAULT '',
	me_map varchar(255) DEFAULT '',

	me_email text,
	phone text,
	fax text,
	me_url text,
	me_phone_number_id int(11) unsigned DEFAULT '0',
	me_emailaddress_id int(11) unsigned DEFAULT '0',

	me_import_id int(11) unsigned DEFAULT '0',
	me_import_source text,
	me_import_external_id text,

	me_briefanrede varchar(255) DEFAULT '',
	me_contact_verband int(11) unsigned DEFAULT '0' NOT NULL,
	me_resp_personid int(11) unsigned DEFAULT '0',

	acl_owner  int(11) DEFAULT '0',
	acl_read_groups varchar(255) DEFAULT '' NOT NULL,
	acl_write_groups varchar(255) DEFAULT '' NOT NULL,

	frontend_user int(11) unsigned,

	me_comment text,

	me_newsletter_test tinyint(1) unsigned DEFAULT '0' NOT NULL,
	messages int(11) unsigned DEFAULT '0',
	me_extra_text1 text,
	me_extra_text2 text,
	me_extra_text3 text,
	me_extra_text4 text,
	me_extra_text5 text,
	me_extra_field1 text,
	me_extra_field2 text,
	me_extra_field3 text,
	me_tag_id int(11) unsigned DEFAULT '0',

    	me_is_family tinyint(1) unsigned DEFAULT '0',
	me_family int(11) DEFAULT '0',
	me_invoice_to int(11) DEFAULT '0',
    	me_is_sammelinvoice tinyint(1) unsigned DEFAULT '0',

	me_remark varchar(255) DEFAULT '',
	me_erhaelt_invoice tinyint(1) unsigned DEFAULT '0',
	me_invoicesadresse int(11) DEFAULT '0',
	me_date_of_birth date,
	me_verstorben tinyint(1) unsigned DEFAULT '0',
	me_mitgliedschaften_buero tinyint(1) unsigned DEFAULT '0',
	me_diplom_jahr int(11) DEFAULT NULL,
	me_status int(11) DEFAULT '0',
	me_todestag date DEFAULT NULL,
	me_profession varchar(255) DEFAULT '',

	me_no_employees tinyint(1) unsigned DEFAULT '0',
	is_lehrbetrieb tinyint(1) unsigned DEFAULT '0' NOT NULL,
	me_bbf tinyint(1) unsigned DEFAULT '0' NOT NULL,
	organisation_category int(11) unsigned DEFAULT '0',

	me_certificates int(11) unsigned DEFAULT '0',
	me_account varchar(255) DEFAULT '',
	me_password varchar(255) DEFAULT '',
	hash varchar(255) DEFAULT '',

	me_heimatort	text,
	me_title_abrev varchar(255) DEFAULT '',
	me_titel_name varchar(255) DEFAULT '',
	me_title_title varchar(255) DEFAULT '',
	me_ssmafperson_year int(11) DEFAULT '0',
	me_diplom_name varchar(255) DEFAULT '',
	me_patent_vorhanden tinyint(1) unsigned DEFAULT '0',
	me_patent_year int(11) DEFAULT NULL,
	me_amoid int(11) DEFAULT '0',
	me_title_nr int(11) DEFAULT '0',
	me_year_of_birth int(11) DEFAULT '0',
	me_status_organisation text,
	me_mail_alias text,
	me_mail_geosuisse text,
	me_mail_igs text,
	me_extra_firma text,
	me_firma text,
	me_firma_address varchar(255) DEFAULT '',
	me_firma_address2 varchar(255) DEFAULT '',
	me_firma_address3 varchar(255) DEFAULT '',
	me_firma_zip varchar(255) DEFAULT '',
	me_firma_city varchar(255) DEFAULT '',
	me_firma_country_abrev varchar(255) DEFAULT '',
        me_bildungspass tinyint(1) unsigned DEFAULT '0' NOT NULL,

	me_is_lernende tinyint(1) unsigned DEFAULT '0',
	me_is_berufsbildner tinyint(1) unsigned DEFAULT '0',
	me_berufsbildner int(11) unsigned,
	me_klasse text,
	me_bm_typ	text,
	me_lb_typ	text,
	me_branche	text,
	me_lehrbetrieb int(11) unsigned DEFAULT '0',
	me_extern_id_namespace	text,
	me_extern_id	text,

);

#
# Table structure for table 'tx_igscrm_domain_model_language'
#
CREATE TABLE tx_igscrm_domain_model_language (
	lg_name varchar(255) DEFAULT '' NOT NULL,
	lg_short varchar(255) DEFAULT '' NOT NULL,
	lg_code varchar(255) DEFAULT '' NOT NULL,
	lg_locale varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_anrede'
#
CREATE TABLE tx_igscrm_domain_model_anrede (
	an_name varchar(255) DEFAULT '' NOT NULL,
	letter_formal_de varchar(255) DEFAULT '' NOT NULL,
	letter_formal_fr varchar(255) DEFAULT '' NOT NULL,
	letter_formal_it varchar(255) DEFAULT '' NOT NULL,
	letter_informal_de varchar(255) DEFAULT '' NOT NULL,
	letter_informal_fr varchar(255) DEFAULT '' NOT NULL,
	letter_informal_it varchar(255) DEFAULT '' NOT NULL,
	an_name_fr varchar(255) DEFAULT '' NOT NULL,
	an_name_it varchar(255) DEFAULT '' NOT NULL,
	hide_in_letter_address int(11) unsigned DEFAULT '0' NOT NULL,
);


#
# Table structure for table 'tx_igscrm_domain_model_commission'
#
CREATE TABLE tx_igscrm_domain_model_commission (
	name varchar(255) DEFAULT '' NOT NULL,
	cl_commissionid int(11) unsigned DEFAULT '0' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_kanton'
#
CREATE TABLE tx_igscrm_domain_model_kanton (
	ka_name varchar(255) DEFAULT '' NOT NULL,
	ka_abkuerzung varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_phonecategory'
#
CREATE TABLE tx_igscrm_domain_model_phonecategory (
	pc_name varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_verband'
#
CREATE TABLE tx_igscrm_domain_model_verband (
	name varchar(255) DEFAULT '' NOT NULL,
	name_de varchar(255) DEFAULT '' NOT NULL,
	name_fr varchar(255) DEFAULT '' NOT NULL,
	name_it varchar(255) DEFAULT '' NOT NULL,
	name_en varchar(255) DEFAULT '' NOT NULL,
	name_hr varchar(255) DEFAULT '' NOT NULL,
	name_fibu varchar(255) DEFAULT '' NOT NULL,
	bfs_uid varchar(255) DEFAULT '' NOT NULL,
	path_uids varchar(255) DEFAULT '' NOT NULL,
	parent int(11) DEFAULT '0' NOT NULL,
	addon varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	url varchar(255) DEFAULT '' NOT NULL,
	groups varchar(255) DEFAULT '' NOT NULL,
	banking_customer_identification varchar(255) DEFAULT '' NOT NULL,
	iban varchar(255) DEFAULT '' NOT NULL,
	qr_iban varchar(255) DEFAULT '' NOT NULL,
	bank_name varchar(255) DEFAULT '' NOT NULL,
	bank_zip_city varchar(255) DEFAULT '' NOT NULL,
	bank_konto varchar(255) DEFAULT '' NOT NULL,
	mwst_nr varchar(255) DEFAULT '' NOT NULL,
	invoice_from_email varchar(255) DEFAULT '' NOT NULL,
	invoice_from_name varchar(255) DEFAULT '' NOT NULL,
	invoice_test_email varchar(255) DEFAULT '' NOT NULL,
	invoice_bcc_email varchar(255) DEFAULT '' NOT NULL,
	invoice_periode_length_in_month int(11),
	invoice_css text,
	invoice_text text,
        tax_rate decimal(11,2) DEFAULT '0.00' NOT NULL,
	tax_behavior smallint(5) unsigned,	
	use_pp int(11) DEFAULT '0' NOT NULL,
	export_config text,
	logo int(11) unsigned NOT NULL default '0',
	logo_width int(11) unsigned NOT NULL default '0',
	logo_mail int(11) unsigned NOT NULL default '0',
	logo_mail_width int(11) unsigned NOT NULL default '0',
	street text,
	street_number text,
	address2 text,
	address3 text,
	country_iso_code varchar(255),
	zip text,
	city varchar(255),
	city_de varchar(255),
	city_fr varchar(255),
	city_it varchar(255),
	city_en varchar(255),
	phone text,
	acl_owner  int(11) DEFAULT '0',
	acl_read_groups varchar(255) DEFAULT '' NOT NULL,
	acl_write_groups varchar(255) DEFAULT '' NOT NULL,
	edit_js text,
	edit_css text,
	template_name text,
	field_list text,
	title_extra_textfield1 varchar(255) DEFAULT '' NOT NULL,
	title_extra_textfield2 varchar(255) DEFAULT '' NOT NULL,
	title_extra_textfield3 varchar(255) DEFAULT '' NOT NULL,
	title_extra_textarea1 varchar(255) DEFAULT '' NOT NULL,
	title_extra_textarea2 varchar(255) DEFAULT '' NOT NULL,
	title_extra_textarea3 varchar(255) DEFAULT '' NOT NULL,
	title_external_id varchar(255) DEFAULT '' NOT NULL,
	veteranen_alter int(11) DEFAULT '0' NOT NULL,
	alterskategorie_mode int(11) DEFAULT '0' NOT NULL,
	journal_mode int(11) DEFAULT '0' NOT NULL,
	invoice_mode int(11) DEFAULT '0' NOT NULL,
	person_uid_attribute varchar(255) DEFAULT '' NOT NULL,
	title_organisation_id varchar(255) DEFAULT '' NOT NULL,
	title_journal_is_free1 varchar(255) DEFAULT '' NOT NULL,
	title_journal_is_free2 varchar(255) DEFAULT '' NOT NULL,
	title_tags varchar(255) DEFAULT '' NOT NULL,
	title_commissions varchar(255) DEFAULT '' NOT NULL,
	title_categories varchar(255) DEFAULT '' NOT NULL,

	exports int(11) unsigned DEFAULT '0' NOT NULL,
	extra_betrag_title varchar(255) DEFAULT '' NOT NULL,
	extra_betrag_value double(11,2) DEFAULT '0.00' NOT NULL,
	invoice_base_text text,
	sender_line varchar(255) DEFAULT '' NOT NULL,

	test_dates tinyint(1) unsigned DEFAULT '0',
	show_invoice_address int(11) DEFAULT '1',
	languages int(11) unsigned DEFAULT '0' NOT NULL,
	use_own_address_number tinyint(1) unsigned DEFAULT '0',
	post_client_id varchar(32) DEFAULT '' NOT NULL,
	post_client_secret varchar(32) DEFAULT '' NOT NULL,
	post_franking_license varchar(32) DEFAULT '' NOT NULL,
);


#
# Table structure for table 'tx_igscrm_domain_model_zeitschrift'
#
CREATE TABLE tx_igscrm_domain_model_zeitschrift (
	name varchar(255) DEFAULT '' NOT NULL,
	betrag double(11,2) DEFAULT '0.00' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	preise int(11) unsigned DEFAULT '0' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_preise'
#
CREATE TABLE tx_igscrm_domain_model_preise (
	mitgliedschaften int(11) unsigned DEFAULT '0' NOT NULL,
	zeitschrift int(11) unsigned DEFAULT '0' NOT NULL,
	anrede int(11) unsigned DEFAULT '0' NOT NULL,

	alter_in_jahr_von int(11) DEFAULT '0' NOT NULL,
	alter_in_jahr_bis int(11) DEFAULT '0' NOT NULL,
	betrag double(11,2) DEFAULT '0.00' NOT NULL,
	invoicestext varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_export'
#
CREATE TABLE tx_igscrm_domain_model_export (
	verband int(11) unsigned DEFAULT '0' NOT NULL,

	name varchar(255) DEFAULT '' NOT NULL,
	class_name varchar(255) DEFAULT '' NOT NULL,
	function_name varchar(255) DEFAULT '' NOT NULL,
	filename varchar(255) DEFAULT '' NOT NULL,
	fields text,
	config text,
);

#
# Table structure for table 'tx_igscrm_domain_model_phonenumber'
#
CREATE TABLE tx_igscrm_domain_model_phonenumber (
	contact int(11) unsigned DEFAULT '0' NOT NULL,

	pn_phonenumber varchar(255) DEFAULT '' NOT NULL,
	pn_phonecategoryid int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_emailcategory'
#
CREATE TABLE tx_igscrm_domain_model_emailcategory (
	ec_name varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_emailaddress'
#
CREATE TABLE tx_igscrm_domain_model_emailaddress (
	contact int(11) unsigned DEFAULT '0' NOT NULL,

	ea_emailaddress varchar(255) DEFAULT '' NOT NULL,
	ea_emailcategoryid int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_mitgliedschaft'
#
CREATE TABLE tx_igscrm_domain_model_mitgliedschaft (

	name varchar(255) DEFAULT '' NOT NULL,
	code varchar(255) DEFAULT '' NOT NULL,
	limit_to_type varchar(255),
	betrag varchar(255) DEFAULT '' NOT NULL,
	betrag_is_total tinyint(4) unsigned DEFAULT '0' NOT NULL,
	invoicestext text,
	no_person tinyint(4) unsigned DEFAULT '0' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	preise int(11) unsigned DEFAULT '0' NOT NULL,
	card int(11) unsigned DEFAULT '0'
);

#
# Table structure for table 'tx_igscrm_domain_model_message'
#
CREATE TABLE tx_igscrm_domain_model_message (

       contact int(11) unsigned DEFAULT '0' NOT NULL,

	title varchar(255) DEFAULT '' NOT NULL,
	content text,
	create_date datetime,

);

#
# Table structure for table 'tx_igscrm_domain_model_category'
#
CREATE TABLE tx_igscrm_domain_model_category (
	name varchar(255) DEFAULT '' NOT NULL,
	betrag varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_tagverband'
#
CREATE TABLE tx_igscrm_domain_model_tagverband (
	name varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',

);

CREATE TABLE tx_igscrm_domain_model_tagrole (
       name varchar(255) DEFAULT '' NOT NULL,
       tag  int(11) unsigned DEFAULT '0',
       show_mail tinyint(1) unsigned DEFAULT '0',

);
CREATE TABLE tx_igscrm_domain_model_tagfield (
       title varchar(255) DEFAULT '' NOT NULL,
       field_number  int(11) unsigned DEFAULT '0',
       tag  int(11) unsigned DEFAULT '0',
       is_translated tinyint(1) unsigned DEFAULT '0',
);
CREATE TABLE tx_igscrm_domain_model_contacttag (
        contact int(11) unsigned,
        tag int(11) unsigned,
        tagrole int(11) unsigned,
	textfield1_de varchar(255),
	textfield1_en varchar(255),
	textfield1_fr varchar(255),
	textfield1_it varchar(255),
	textfield2_de varchar(255),
	textfield2_en varchar(255),
	textfield2_fr varchar(255),
	textfield2_it varchar(255),
	textfield3_de varchar(255),
	textfield3_en varchar(255),
	textfield3_fr varchar(255),
	textfield3_it varchar(255),
);

CREATE TABLE tx_igscrm_domain_model_api (
	name varchar(255) DEFAULT '' NOT NULL,
	api_key varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	acl text,
);


#
# Table structure for table 'tx_igscrm_domain_model_categoryorganisation'
#
CREATE TABLE tx_igscrm_domain_model_categoryorganisation (
	co_name varchar(255) DEFAULT '' NOT NULL,
	limit_to_type varchar(255),
	icon int(11) unsigned NOT NULL default '0',
	image int(11) unsigned NOT NULL default '0',
);



#
# Table structure for table 'tx_igscrm_domain_model_section'
#
CREATE TABLE tx_igscrm_domain_model_section (
	name varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
);


#
# Table structure for table 'tx_igscrm_domain_model_sektion'
#
CREATE TABLE tx_igscrm_domain_model_sektion (
	name varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	link varchar(255) DEFAULT '',
);


#
# Table structure for table 'tx_igscrm_domain_model_kursteilnehmer'
#
CREATE TABLE tx_igscrm_domain_model_kursteilnehmer (
	kt_startdatum date,
	kt_enddatum date,
	kt_dauer varchar(255) DEFAULT '' NOT NULL,
	kt_person int(11) unsigned DEFAULT '0',
	kt_kurse int(11) unsigned DEFAULT '0',
	kt_kursmodule int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igscrm_domain_model_kurse'
#
CREATE TABLE tx_igscrm_domain_model_kurse (
	ku_name varchar(255) DEFAULT '' NOT NULL,
	ku_name_fr varchar(255) DEFAULT '' NOT NULL,
	ku_fussnote tinyint(1) unsigned DEFAULT '0' NOT NULL,
	ku_kursmodule int(11) unsigned DEFAULT '0' NOT NULL,
	ku_art int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_domain_model_kursmodule'
#
CREATE TABLE tx_igscrm_domain_model_kursmodule (
	kurse int(11) unsigned DEFAULT '0' NOT NULL,

	km_name varchar(255) DEFAULT '' NOT NULL,
	km_name_fr varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igscrm_domain_model_kursart'
#
CREATE TABLE tx_igscrm_domain_model_kursart (
	ka_name varchar(255) DEFAULT '' NOT NULL,
	ka_name_fr varchar(255) DEFAULT '' NOT NULL,
);


#
# Table structure for table 'tx_igscrm_domain_model_tag'
#
CREATE TABLE tx_igscrm_domain_model_tag (
	name varchar(255) DEFAULT '' NOT NULL,
	usergroup varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	tagverband int(11) unsigned DEFAULT '0',
    	has_roles tinyint(1) unsigned DEFAULT '0',
);


CREATE TABLE tx_igscrm_domain_model_card (

	title varchar(255) DEFAULT '' NOT NULL,
	field1_label varchar(255) DEFAULT '' NOT NULL,
	field1_value varchar(255) DEFAULT '' NOT NULL,
	field2_label varchar(255) DEFAULT '' NOT NULL,
	field2_value varchar(255) DEFAULT '' NOT NULL,
	field3_label varchar(255) DEFAULT '' NOT NULL,
	field3_value varchar(255) DEFAULT '' NOT NULL,
	back_text text,
	background_image_odd int(11) unsigned NOT NULL default '0',
	background_image_even int(11) unsigned NOT NULL default '0',
	letter_title varchar(255) DEFAULT '' NOT NULL,
	letter_text text,
	letter_new_title varchar(255) DEFAULT '' NOT NULL,
	letter_new_text text,
	period varchar(255),
	enable_wallet tinyint(1) DEFAULT '0',
	letter_closing text,
	verband int(11) unsigned DEFAULT '0',
);

#
# Table structure for table 'tx_igscrm_contact_commission_mm'
#
CREATE TABLE tx_igscrm_contact_commission_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_contact_meorganisationid_organisation_mm'
#
CREATE TABLE tx_igscrm_contact_meorganisationid_organisation_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_contact_category_mm'
#
CREATE TABLE tx_igscrm_contact_category_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);


#
# Table structure for table 'tx_igscrm_contact_sektion_mm'
#
CREATE TABLE tx_igscrm_contact_sektion_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);


#
# Table structure for table 'tx_igscrm_organisation_categoryorganisation_mm'
#
CREATE TABLE tx_igscrm_organisation_categoryorganisation_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_kursteilnehmer_kursmodule_mm'
#
CREATE TABLE tx_igscrm_kursteilnehmer_kursmodule_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);



#
# Table structure for table 'tx_igscrm_contact_tag_mm'
#
CREATE TABLE tx_igscrm_contact_tag_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);


#
# Table structure for table 'tx_igscrm_domain_model_contactverband'
#
CREATE TABLE tx_igscrm_domain_model_contactverband (
       contact int(11) unsigned DEFAULT '0' NOT NULL,

	active smallint(5) unsigned DEFAULT '0' NOT NULL,
	start_date date DEFAULT NULL,
	end_date date DEFAULT NULL,
	journal int(11) unsigned DEFAULT '0',
	journal_end date DEFAULT NULL,
	journal_freiwillig smallint(5) unsigned DEFAULT '0' NOT NULL,
	journal_is_free1 smallint(5) unsigned DEFAULT '0' NOT NULL,
	journal_is_free2 smallint(5) unsigned DEFAULT '0' NOT NULL,
	extra_textfield1 text,
	extra_textfield2 text,
	extra_textfield3 text,
	extra_textarea1 text,
	extra_textarea2 text,
	extra_textarea3 text,
	external_id varchar(255) DEFAULT '' NOT NULL,
	import_source text,
	address varchar(255) DEFAULT '' NOT NULL,
	address2 varchar(255) DEFAULT '' NOT NULL,
	address3 varchar(255) DEFAULT '' NOT NULL,
	pobox varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	verband int(11) unsigned DEFAULT '0',
	mitgliedschaft int(11) unsigned DEFAULT '0',
	company int(11) unsigned DEFAULT '0',
	organisation_id int(11) unsigned DEFAULT '0',
	tags int(11) unsigned DEFAULT '0' NOT NULL,
	commissions int(11) unsigned DEFAULT '0' NOT NULL,
	sektionen int(11) unsigned DEFAULT '0' NOT NULL,
	categories int(11) unsigned DEFAULT '0' NOT NULL,
	organisations int(11) unsigned DEFAULT '0' NOT NULL,
	invoice_mode int(11) DEFAULT '0' NOT NULL,
	invoice_address int(11) unsigned DEFAULT '0',
	invoice_delivery_mode int(11) DEFAULT '0' NOT NULL,
	invoice_mail varchar(255) DEFAULT '' NOT NULL,
	invoice_mail_subject varchar(255) DEFAULT '' NOT NULL,
	invoice_reference varchar(255) DEFAULT '' NOT NULL,
	invoice_description text,
	correspondence_mode int(11) DEFAULT '0' NOT NULL,
	correspondence_address int(11) unsigned DEFAULT '0',
	correspondence_delivery_mode int(11) DEFAULT '0' NOT NULL,
	UNIQUE tx_igscrm_index_contactverband (contact,verband),
);

CREATE TABLE tx_igscrm_domain_model_contactcontact (
	active smallint(1) unsigned NOT NULL DEFAULT '0',
	start_date date DEFAULT NULL,
	end_date date DEFAULT NULL,
	title varchar(255) NOT NULL DEFAULT '',
	acl int(11) DEFAULT '0' NOT NULL,
	contact int(11) unsigned DEFAULT '0',
	organisation int(11) unsigned DEFAULT '0',
	relation_type int(11) unsigned DEFAULT '0',
	relation_function int(11) unsigned DEFAULT '0'
);

CREATE TABLE tx_igscrm_domain_model_relationtype (
	name varchar(255) NOT NULL DEFAULT ''
);

CREATE TABLE tx_igscrm_domain_model_relationfunction (
	name varchar(255) NOT NULL DEFAULT ''
);


#
# Table structure for table 'tx_igscrm_contactverband_tag_mm'
#
CREATE TABLE tx_igscrm_contactverband_tag_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_contactverband_commission_mm'
#
CREATE TABLE tx_igscrm_contactverband_commission_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_contactverband_sektion_mm'
#
CREATE TABLE tx_igscrm_contactverband_sektion_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igscrm_contactverband_category_mm'
#
CREATE TABLE tx_igscrm_contactverband_category_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);
#
# Table structure for table 'tx_igscrm_contactverband_organisation_mm'
#
CREATE TABLE tx_igscrm_contactverband_organisation_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE tx_igscrm_domain_model_branchen (
	name varchar(255) DEFAULT '' NOT NULL,
	parent int(11) DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_igscrm_organisation_branchen_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE tx_igscrm_organisation_warengruppe_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE tx_igscrm_organisation_produkte_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);
CREATE TABLE tx_igscrm_verband_language_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);
CREATE TABLE tx_igscrm_domain_model_certificate (
	name varchar(255) NOT NULL DEFAULT '',
	limit_to_type varchar(255) NOT NULL DEFAULT '',
);

CREATE TABLE tx_igscrm_domain_model_contactcertificate (
	academy varchar(255) NOT NULL DEFAULT '',
	certificate_year int DEFAULT NULL,
	certificate int(11) unsigned DEFAULT '0',
	contact int(11) unsigned DEFAULT '0',
);
CREATE TABLE tx_igfibu_domain_model_invoice (
       mitgliedschaft int(11) unsigned,
);
CREATE TABLE tx_igfibu_domain_model_invoiceitem (
       membership int(11) unsigned,
       journal int(11) unsigned,
);
