<?php

namespace InternetGalerie\Igshop2\Controller;

use Internetgalerie\IgBackendHelpers\Controller\AbstractBackendTableListController;
use InternetGalerie\Igshop2\Domain\Repository\PropertycategoryRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Backend\Configuration\BackendUserConfiguration;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class BackendPropertycategoryController extends AbstractBackendTableListController
{
    protected string $tableName = 'tx_igshop2_domain_model_propertycategory';

    protected string $entryIdSearchAttribute = 'parent';
    // default is 'parent'
    protected PropertycategoryRepository $propertycategoryRepository;

    public function injectPropertycategoryRepository(PropertycategoryRepository $propertycategoryRepository): void
    {
        $this->propertycategoryRepository = $propertycategoryRepository;
    }

    public function indexAction(): ResponseInterface
    {
        $selectedCategory = null;
        if ($this->entryId > 0) {
            $selectedCategory = $this->propertycategoryRepository->findByUidBackend($this->entryId);
        }

        $backendUserConfiguration = GeneralUtility::makeInstance(BackendUserConfiguration::class);
        if ($this->entryId === null || $this->pageUid === null) {
            $this->pageUid = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.pageUid');
            $this->entryId = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.entryId');
            $selectedCategory = $this->propertycategoryRepository->findByUidBackend($this->entryId);
        }

        $backendUserConfiguration->set('BackendComponents.States.Shop.pageUid', $this->pageUid);
        $backendUserConfiguration->set('BackendComponents.States.Shop.entryId', $this->entryId);

        if ($selectedCategory) {
            $defVals = [
                $this->tableName => [
                    'parent' => $selectedCategory->getUid(),
                ],
            ];
        } else {
            $defVals = [];
        }

        $this->view->assignMultiple([
            'defVals' => $defVals,
            'selectedCategory' => $selectedCategory,
        ]);

        //var_dump($defVals, $this->entryId);exit(0);
        return parent::indexAction();
    }
}
