<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use Psr\Http\Message\ResponseInterface;

/**
 * CategoryController
 */
class CategoryController extends ActionController
{
    public function __construct(
        protected CategoryRepository $categoryRepository
    ) {
    }

    public function categoryNavAction(): ResponseInterface
    {
        $topCategoryUid = $this->settings['flexform']['group'];
        $topCategory = $this->categoryRepository->findByUid($topCategoryUid);

        $subcategories = $this->categoryRepository->findByParentAndProductsOrSubcategories($topCategory);

        //$subcategories = $topCategory->getSubcategories();
        $categoryCount = count($subcategories);
        //$splitLetter = $categoryCount > 1 ? chr(ord($subcategories[intval(floor($categoryCount / 2))]->getFirstLetter()) + 1) : 0;
        $splitLetter = $categoryCount > 1 ? chr(
            ord($subcategories[intval(floor($categoryCount / 2))]['firstLetter']) + 1
        ) : 0;
        //$this->view->assign('topCategory', $topCategory);
        $this->view->assign('subcategories', $subcategories);
        $this->view->assign('splitLetter', $splitLetter);

        return $this->htmlResponse();
    }
}
