<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2015
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * OrderProduct
 */
class AbstractOrderProduct extends AbstractEntity
{
    /**
     * unitPrice
     *
     * @var float
     */
    protected $unitPrice = 0.0;

    /**
     * amount
     *
     * @var integer
     */
    protected $amount = 0;

    /**
     * price
     *
     * @var float
     */
    protected $price = 0.0;

    /**
     * prodOptions
     *
     * @var string
     */
    protected $prodOptions = '';

    /**
     * product
     *
     * @var Product
     */
    protected $product = null;

    /**
     * Returns the unitPrice
     *
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }

    /**
     * Sets the unitPrice
     *
     * @param float $unitPrice
     */
    public function setUnitPrice($unitPrice): void
    {
        $this->unitPrice = $unitPrice;
    }

    /**
     * Returns the amount
     *
     * @return integer
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Sets the amount
     *
     * @param integer $amount
     */
    public function setAmount($amount): void
    {
        $this->amount = $amount;
        $this->setPrice($this->amount * $this->getUnitPrice());
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the prodOptions
     *
     * @return string
     */
    public function getProdOptions()
    {
        return $this->prodOptions;
    }

    public function getProdOptionsArray()
    {
        return unserialize($this->prodOptions);
    }

    public function getProdOptionsWithAmountArray()
    {
        $options = unserialize($this->prodOptions);
        $options['amount'] = $this->getAmount();
        return $options;
    }

    /**
     * Sets the prodOptions
     *
     * @param string $prodOptions
     */
    public function setProdOptions($prodOptions): void
    {
        $this->prodOptions = $prodOptions;
    }

    /**
     * Returns the product
     *
     * @return Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Sets the product
     */
    public function setProduct(Product $product): void
    {
        $this->product = $product;
    }

    /**
     * Gets the right Price from the product, depending if there is
     * a member or there is a speical price
     * @param Currency $currency $isMember
     */
    public function calcPrice($currency, $isMember = false): void
    {
        $prodOptions = unserialize($this->prodOptions);
        $product = $this->getProduct();
        if (is_object($product)) {
            $this->unitPrice = $product->getFinalPrice(
                $currency,
                $prodOptions['optionWithPrice'] ?? null,
                $this->amount,
                false,
                $isMember
            );
        }

        $this->price = $this->amount * $this->unitPrice;
    }

    public function getProductName()
    {
        return $this->getProduct()
->getName();
    }

    /**
     * unserializes its options and sets all options given by $request
     */
    public function setSerializedOptions($request): void
    {
        // Serialisierte Optionen holen
        $options = unserialize($this->getProdOptions());

        // Variabel die Optionen einfügen
        foreach ($request as $key => $value) {
            $options[$key] = $value;
        }

        // Optionen speichern
        $this->setProdOptions(serialize($options));
    }

    public function getPackaging()
    {
        $prodOptions = unserialize($this->getProdOptions());

        if ($prodOptions['packaging']) {
            foreach ($this->getProduct()->getOptionsPackaging() as $packaging) {
                if ($prodOptions['packaging'] == $packaging->getUid()) {
                    return $packaging;
                }
            }
        }

        return null;
    }

    public function getColor()
    {
        $prodOptions = unserialize($this->getProdOptions());

        if ($prodOptions['color']) {
            foreach ($this->getProduct()->getOptionsColor() as $color) {
                if ($prodOptions['color'] == $color->getUid()) {
                    return $color;
                }
            }
        }

        return null;
    }

    public function getOptionsRaw()
    {
        $options = unserialize($this->getProdOptions());
        $product = $this->getProduct();
        $ret = '';

        if ($product) {
            // Farben
            if (isset($options['color'])) {
                $colors = $product->getOptionsColor();
                foreach ($colors as $color) {
                    if ($color->getUid() == $options['color']) {
                        if ($ret) {
                            $ret .= '<br />';
                        }

                        $ret .= 'Farbe: ' . $color->getName();
                    }
                }
            }

            // Grösse
            if (isset($options['size'])) {
                $sizes = $product->getOptionsSize();
                foreach ($sizes as $size) {
                    if ($size->getUid() == $options['size']) {
                        if ($ret) {
                            $ret .= '<br />';
                        }

                        $ret .= 'Grösse: ' . $size->getName();
                    }
                }
            }

            // Verpackung
            if (isset($options['packaging'])) {
                $packagings = $product->getOptionsPackaging();
                foreach ($packagings as $packaging) {
                    if ($packaging->getUid() == $options['packaging']) {
                        if ($ret) {
                            $ret .= '<br />';
                        }

                        $ret .= 'Verpackung: ' . $packaging->getName();
                    }
                }
            }

            // Andere Optionen
            if (isset($options['options'])) {
                $multiOptions = $product->getOptionEntry();
                foreach ($multiOptions as $option) {
                    foreach ($option->getOptions() as $singleOption) {
                        if ($options['options'][$option->getUid()] == $singleOption->getUid()) {
                            if ($ret) {
                                $ret .= '<br />';
                            }

                            $ret .= $option->getName() . ': ' . $singleOption->getName();
                        }
                    }
                }
            }

            if (isset($options['optionsInput'])) {
                foreach ($this->product->getOptionsInput() as $o) {
                    foreach ($options['optionsInput'] as $uid => $value) {
                        if ($o->getUid() == $uid) {
                            if ($ret) {
                                $ret .= '<br />';
                            }

                            $ret .= $o->getLabel() . ': ' . nl2br((string) $value);
                        }
                    }
                }
            }

            $optionWithPrice = $this->getOptionWithPrice();
            if ($optionWithPrice) {
                if ($ret) {
                    $ret .= '<br />';
                }

                $ret .= $optionWithPrice->getName();
            }

            if (isset($options['products'])) {
                foreach ($this->product->getOptionsProducts() as $o) {
                    foreach ($options['products'] as $uid) {
                        if ($o->getUid() == $uid) {
                            if ($ret) {
                                $ret .= '<br />';
                            }

                            $ret .= $o->getName();
                        }
                    }
                }
            }
        }

        return $ret;
    }

    /**
     * Returns the optionWithPrice
     */
    public function getOptionWithPrice()
    {
        $options = unserialize($this->prodOptions);
        if (isset($options['optionWithPrice'])) {
            foreach ($this->product->getOptionsWithPriceAll() as $o) {
                if ($o->getUid() == $options['optionWithPrice']) {
                    return $o;
                }
            }
        }

        return false;
    }

    /**
     * Returns the optionWithPrice
     */
    public function setOptionWithPrice()
    {
        $options = unserialize($this->prodOptions);
        if ($options['optionWithPrice']) {
            foreach ($this->product->getOptionsWithPriceAll() as $o) {
                if ($o->getUid() == $options['optionWithPrice']) {
                    return $o;
                }
            }
        }

        return false;
    }

    public function getOptionsInput()
    {
        $options = unserialize($this->prodOptions);
        $optionsInput = [];
        if ($options['optionsInput']) {
            foreach ($this->product->getOptionsInput() as $o) {
                foreach ($options['optionsInput'] as $uid => $value) {
                    if ($o->getUid() == $uid) {
                        $optionsInput = [
                            'optionInput' => $o,
                            'value' => $value,
                        ];
                    }
                }
            }
        }

        return $optionsInput;
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        // Existiert ein Bild bei den Optionen mit Preis
        $optionWithPrice = $this->getOptionWithPrice();
        if ($optionWithPrice) {
            $i = $optionWithPrice->getMainImageLocalized();
            if ($i) {
                return $i;
            }
        }

        return $this->product->getMainImageLocalized();
    }

    /**
     * Returns the main Product Mpn
     *
     * @return string
     */
    public function getMainMpn()
    {
        // Existiert ein Bild bei den Optionen mit Preis
        $optionWithPrice = $this->getOptionWithPrice();
        if ($optionWithPrice) {
            $mpn = $optionWithPrice->getMpn();
            if ($mpn) {
                return $mpn;
            }
        }

        return $this->product->getMpn();
    }

    /**
     * Returns the main Product uid
     *
     * @return integer
     */
    public function getMainUid()
    {
        // Existiert ein Bild bei den Optionen mit Preis
        $optionWithPrice = $this->getOptionWithPrice();
        if ($optionWithPrice) {
            $uid = $optionWithPrice->getUid();
            if ($uid) {
                return $uid;
            }
        }

        return $this->product->getUid();
    }

    /**
     * Returns the main Product name
     *
     * @return string
     */
    public function getMainName()
    {
        // Existiert ein Bild bei den Optionen mit Preis
        $optionWithPrice = $this->getOptionWithPrice();
        if ($optionWithPrice) {
            $name = $optionWithPrice->getName();
            if ($name) {
                return $this->getProduct()
->getName() . ' ' . $name;
            }
        }

        return $this->getProduct()
->getName();
    }
}
