<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\Validate;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
class Address extends \FriendsOfTYPO3\TtAddress\Domain\Model\Address
{
    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $gender = '';

    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $firstName = '';

    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $lastName = '';

    /**
     * @var string
     */
    protected $company = '';

    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $address = '';

    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $zip = '';

    /**
     * @var string
     * @Validate("NotEmpty")
     */
    protected $city = '';

    /**
     * moduleSysDmailHtml
     *
     * @var boolean
     */
    protected $moduleSysDmailHtml = false;

    /**
     * @var FeUser
     */
    protected $feUser = null;

    /**
     * @var boolean
     */
    protected $isBillingAddress = false;

    /**
     * @var boolean
     */
    protected $isPrivatePerson = false;

    /**
     * Returns the moduleSysDmailHtml
     *
     * @return boolean
     */
    public function getModuleSysDmailHtml()
    {
        return $this->moduleSysDmailHtml;
    }

    /**
     * Sets the moduleSysDmailHtml
     *
     * @param boolean $moduleSysDmailHtml
     */
    public function setModuleSysDmailHtml($moduleSysDmailHtml): void
    {
        $this->moduleSysDmailHtml = $moduleSysDmailHtml;
    }

    /**
     * Returns the boolean state of moduleSysDmailHtml
     *
     * @return boolean
     */
    public function isModuleSysDmailHtml()
    {
        return $this->moduleSysDmailHtml;
    }

    /**
     * Returns the feUser
     *
     * @return FeUser
     */
    public function getFeUser()
    {
        return $this->feUser;
    }

    /**
     * Sets the feUser
     *
     * @param FeUser $feUser
     */
    public function setFeUser($feUser): void
    {
        $this->feUser = $feUser;
    }

    /**
     * Returns the isBillingAddress
     *
     * @return boolean
     */
    public function getIsBillingAddress()
    {
        return $this->isBillingAddress;
    }

    /**
     * Sets the isBillingAddress
     *
     * @param boolean $isBillingAddress
     */
    public function setIsBillingAddress($isBillingAddress): void
    {
        $this->isBillingAddress = $isBillingAddress;
    }

    /**
     * Returns the isPrivatePerson
     *
     * @return boolean
     */
    public function getIsPrivatePerson()
    {
        return $this->isPrivatePerson;
    }

    /**
     * Sets the isPrivatePerson
     *
     * @param boolean $isPrivatePerson
     */
    public function setIsPrivatePerson($isPrivatePerson): void
    {
        $this->isPrivatePerson = $isPrivatePerson;
    }

    /**
     * Updates the name field to [$firstName $lastName]
     */
    public function updateName(): void
    {
        $name = '';

        if ($this->getFirstName() != '') {
            $name = $this->getFirstName();
        }

        if ($this->getFirstName() != '' && $this->getLastName() != '') {
            $name .= ' ' . $this->getLastName();
        } elseif ($this->getLastName() != '') {
            $name = $this->getLastName();
        }

        $this->setName($name);
    }

    public function getName(): string
    {
        if (parent::getName() == '') {
            $this->updateName();
        }

        return parent::getName();
    }

    /**
     * Returns a JSON representation of the address
     *
     * @return string
     */
    public function getJson()
    {
        return json_encode([
            'uid' => $this->getUid(),
            'email' => $this->getFeUser()
->getEmail(),
            'phone' => $this->getFeUser()
->getTelephone(),
            'gender' => $this->getGender() == 'm' ? 1 : ($this->getGender() == 'f' ? 2 : ''),
            'firstName' => $this->getFirstName(),
            'lastName' => $this->getLastName(),
            'company' => $this->getCompany(),
            'address' => $this->getAddress(),
            'zip' => $this->getZip(),
            'city' => $this->getCity(),
            'country' => $this->getCountry(),
            'isPrivatePerson' => $this->getIsPrivatePerson(),
        ], JSON_UNESCAPED_UNICODE);
    }
}
