<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/**
 * Currency
 */
class Currency extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * short
     *
     * @var string
     */
    protected $short = '';

    /**
     * faktor
     *
     * @var float
     */
    protected $faktor = 0.0;

    /**
     * symbol
     *
     * @var string
     */
    protected $symbol = '';

    /**
     * rounding
     *
     * @var float
     */
    protected $rounding = 0.0;

    /**
     * afterPrice
     *
     * @var boolean
     */
    protected $afterPrice = false;

    /**
     * commaSeparator
     *
     * @var string
     */
    protected $commaSeparator = '';

    /**
     * thousandSeparator
     *
     * @var string
     */
    protected $thousandSeparator = '';

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the short
     *
     * @return string
     */
    public function getShort()
    {
        return $this->short;
    }

    /**
     * Sets the short
     *
     * @param string $short
     */
    public function setShort($short): void
    {
        $this->short = $short;
    }

    /**
     * Returns the faktor
     *
     * @return float
     */
    public function getFaktor()
    {
        return $this->faktor;
    }

    /**
     * Sets the faktor
     *
     * @param float $faktor
     */
    public function setFaktor($faktor): void
    {
        $this->faktor = $faktor;
    }

    /**
     * Returns the symbol
     *
     * @return string
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Sets the symbol
     *
     * @param string $symbol
     */
    public function setSymbol($symbol): void
    {
        $this->symbol = $symbol;
    }

    /**
     * Returns the rounding
     *
     * @return float
     */
    public function getRounding()
    {
        return $this->rounding;
    }

    /**
     * Sets the rounding
     *
     * @param float $rounding
     */
    public function setRounding($rounding): void
    {
        $this->rounding = $rounding;
    }

    /**
     * Returns the afterPrice
     *
     * @return boolean
     */
    public function getAfterPrice()
    {
        return $this->afterPrice;
    }

    /**
     * Sets the afterPrice
     *
     * @param boolean $afterPrice
     */
    public function setAfterPrice($afterPrice): void
    {
        $this->afterPrice = $afterPrice;
    }

    /**
     * Returns the boolean state of afterPrice
     *
     * @return boolean
     */
    public function isAfterPrice()
    {
        return $this->afterPrice;
    }

    /**
     * Returns the commaSeparator
     *
     * @return string
     */
    public function getCommaSeparator()
    {
        return $this->commaSeparator;
    }

    /**
     * Sets the commaSeparator
     *
     * @param string $commaSeparator
     */
    public function setCommaSeparator($commaSeparator): void
    {
        $this->commaSeparator = $commaSeparator;
    }

    /**
     * Returns the thousandSeparator
     *
     * @return string
     */
    public function getThousandSeparator()
    {
        return $this->thousandSeparator;
    }

    /**
     * Sets the thousandSeparator
     *
     * @param string $thousandSeparator
     */
    public function setThousandSeparator($thousandSeparator): void
    {
        $this->thousandSeparator = $thousandSeparator;
    }
}
