<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use InternetGalerie\Igshop2\Domain\Model\Currency;
use InternetGalerie\Igshop2\Domain\Repository\CurrencyRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * OptionWithPrice
 */
class OptionWithPrice extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * gtin
     *
     * @var string
     */
    protected $gtin = '';

    /**
     * gtin
     *
     * @var string
     */
    protected $mpn = '';


    /**
     * price
     *
     * @var float
     */
    protected $price;

    /**
     * priceEuro
     *
     * @var float
     */
    protected $priceEuro;

    /**
     * active
     *
     * @var boolean
     */
    protected $onlySwiss = false;

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;

    /**
     * prices
     *
     * @var ObjectStorage<Productprice>
     * @Cascade
     * @Lazy
     */
    protected $prices = null;

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     * @Cascade
     * @Lazy
     */
    protected $image = null;

    /**
     * deliveryPeriod
     * @var DeliveryPeriod
     * @Lazy
     */
    protected $deliveryPeriod = null;


    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the gtin
     *
     * @return string
     */
    public function getGtin()
    {
        return $this->gtin;
    }

    /**
     * Sets the gtin
     *
     * @param string $gtin
     */
    public function setGtin($gtin): void
    {
        $this->name = $gtin;
    }

    /**
     * Returns the mpn
     *
     * @return string
     */
    public function getMpn()
    {
        return $this->mpn;
    }

    /**
     * Sets the mpn
     *
     * @param string $mpn
     */
    public function setMpn($mpn): void
    {
        $this->name = $mpn;
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the priceEuro
     *
     * @return float
     */
    public function getPriceEuro()
    {
        return $this->priceEuro;
    }

    /**
     * Sets the priceEuro
     *
     * @param float $priceEuro
     */
    public function setPriceEuro($priceEuro): void
    {
        $this->priceEuro = $priceEuro;
    }

    /**
     * Returns the onlySwiss
     *
     * @return boolean
     */
    public function getOnlySwiss()
    {
        return $this->onlySwiss;
    }

    /**
     * Sets the onlySwiss
     *
     * @param boolean $onlySwiss
     */
    public function setOnlySwiss($onlySwiss): void
    {
        $this->onlySwiss = $onlySwiss;
    }

    /**
     * Returns the boolean state of onlySwiss
     *
     * @return boolean
     */
    public function isOnlySwiss()
    {
        return $this->onlySwiss;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Adds a ProductPrice
     */
    public function addPrices(Productprice $prices): void
    {
        $this->prices->attach($prices);
    }

    /**
     * Removes a ProductPrice
     *
     * @param \InternetGalerie\Igshop2\Domain\Model\ProductPrice $pricesToRemove The ProductPrice to be removed
     */
    public function removePrices(Productprice $pricesToRemove): void
    {
        $this->prices->detach($pricesToRemove);
    }

    /**
     * Returns the ProductPrice
     *
     * @return ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\ProductPrice> $prices
     */
    public function getPrices()
    {
        return $this->prices;
    }

    /**
     * Sets the Prices
     *
     * @param ObjectStorage<Productprice> $prices
     */
    public function setPrices(ObjectStorage $prices): void
    {
        $this->prices = $prices;
    }

    public function getOptionPrice(Currency $currency, $amount = 0)
    {
        if ($this->onlySwiss && $currency->getShort() != 'CHF') {
            return null;
        }

        if ($amount > 0 && count($this->prices) > 0) {
            $retPrice = null;
            foreach ($this->prices as $price) {
                //echo($price->getAmount() .'='. $price->getPrice() .'<br />');
                if (!is_object($retPrice) && $price->getAmount() <= $amount) {
                    $retPrice = $price;
                }

                if (is_object($retPrice) && $price->getAmount() <= $amount && $retPrice->getAmount() < $amount) {
                    $retPrice = $price;
                }
            }

            if (is_object($retPrice)) {
                if ($currency->getShort() == 'EUR' && $retPrice->getPriceEuro() != null) {
                    return $retPrice->getPriceEuro();
                }

                return $retPrice->getPrice() * $currency->getFaktor();
            }
        }

        if ($currency->getShort() == 'EUR' && $this->priceEuro != null) {
            return $this->priceEuro;
        }

        return $this->price * $currency->getFaktor();
    }



    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        $imgs = $this->getImage();
        foreach ($imgs as $i) {
            return $i;
        }

        return false;
    }


    /**
     * Sets the image
     *
     * @param ObjectStorage<FileReference> $image
     */
    public function setImage(ObjectStorage $image): void
    {
        $this->image = $image;
    }

    /**
     * @return DeliveryPeriod
     */
    public function getDeliveryPeriod()
    {
        return $this->deliveryPeriod;
    }

    /**
     * @param DeliveryPeriod $deliveryPeriod
     */
    public function setDeliveryPeriod($deliveryPeriod): void
    {
        $this->deliveryPeriod = $deliveryPeriod;
    }


    /**
     * Ist Produkt verfügbar in dieser Währung
     *
     * @return boolean
     */
    public function isAvailable(Currency $currency)
    {
        if ($currency->getShort() == 'EUR' && $this->getPriceEuro() !== null && $this->getPriceEuro() <= 0) {
            return false;
        }

        return true;
    }


    /**
     * Returns the correct price, if there is set a special price order the customer is a member
     */
    public function getFinalPrice(Currency $currency): ?float
    {
        if (!$this->isAvailable($currency)) {
            //&& $notAvailableText !== false) {
            return null;//notAvailableText;
        }

        if ($currency->getShort() == 'EUR' && $this->getPriceEuro() !== null) {
            return $this->getPriceEuro();
        }

        return $this->getPrice() * $currency->getFaktor();
    }

    public function getCurrencyClasses()
    {
        $content = '';
        $currencyRepository = GeneralUtility::makeInstance(CurrencyRepository::class);
        $currencies = $currencyRepository->findAllForPrices();
        foreach ($currencies as $currency) {
            if ($this->isAvailable($currency)) {
                if ($content) {
                    $content .= ' ';
                }

                $content .= 'currency-' . $currency->getShort();
            }
        }

        return $content;
    }


    /**
     * Get the value of description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set the value of description
     *
     * @param string $description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->prices = new ObjectStorage();
        $this->image = new ObjectStorage();
    }
}
