<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Order extends AbstractOrder
{
    protected string $productClass = OrderProduct::class;

    /**
     * products
     *
     * @var ObjectStorage<OrderProduct>
     * @Cascade
     */
    protected $products = null;

    /**
     * cart
     * 
     * @var Cart
     */
    protected $cart = null;

    protected ?Shipping $shipping;
    protected float $shippingAmount = 0.0;

    /**
     * Returns the products
     *
     * @return ObjectStorage<OrderProduct> $products
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * Adds a OrderProduct
     * 
     * @param OrderProduct $product
     */
    public function addProduct($product): void
    {
        $this->products->attach($product);
        $this->mustCalculateTotal = true;
    }

    /**
     * Removes a OrderProduct
     *
     * @param OrderProduct $productToRemove The OrderProduct to be removed
     */
    public function removeProduct($productToRemove): void
    {
        $this->products->detach($productToRemove);
        $this->mustCalculateTotal = true;
    }

    /**
     * @return Cart
     */
    public function getCart()
    {
        return $this->cart;
    }

    /**
     * @param Cart $cart 
     * @return void 
     */
    public function setCart($cart)
    {
        $this->cart = $cart;
    }

    public function getShipping(): ?Shipping
    {
        return $this->shipping;
    }

    public function setShipping(?Shipping $shipping): void
    {
        $this->shipping = $shipping;
    }

    public function getShippingAmount(): float
    {
        return $this->shippingAmount;
    }

    public function setShippingAmount(float $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }
}