<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * PaymentMethod
 */
class PaymentMethod extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * controller
     *
     * @var string
     */
    protected $controller = '';

    /**
     * code
     *
     * @var string
     */
    protected $code = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * mailtext
     *
     * @var string
     */
    protected $mailtext = '';

    /**
     * noPorto
     *
     * @var bool
     */
    protected $noPorto = false;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the controller
     *
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * Sets the controller
     *
     * @param string $controller
     */
    public function setController($controller): void
    {
        $this->controller = $controller;
    }

    /**
     * Returns the code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Sets the code
     *
     * @param string $code
     */
    public function setCode($code): void
    {
        $this->code = $code;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the mailtext
     *
     * @return string
     */
    public function getMailtext()
    {
        return $this->mailtext;
    }

    /**
     * Sets the mailtext
     *
     * @param string $mailtext
     */
    public function setMailtext($mailtext): void
    {
        $this->mailtext = $mailtext;
    }

    /**
     * Returns the noPorto
     *
     * @return bool
     */
    public function getNoPorto()
    {
        return $this->noPorto;
    }

    /**
     * Sets the noPorto
     *
     * @param bool $noPorto
     */
    public function setNoPorto($noPorto): void
    {
        $this->noPorto = $noPorto;
    }

    /**
     * Returns the boolean state of noPorto
     *
     * @return bool
     */
    public function isNoPorto()
    {
        return $this->noPorto;
    }
}
