<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Core\Resource\FileRepository;
use InternetGalerie\Igshop2\Domain\Repository\OptionWithPriceRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/**
 * Product
 */
class Product extends AbstractEntity
{
    /**
     * optionWithPriceRepository
     *
     * @var ObjectStorage<OptionWithPrice>
     * @Lazy
     */
    public $resOptionSizePrice = null;

    /**
     * productid
     *
     * @var string
     */
    protected $productid = '';

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * name
     *
     * @var string
     */
    protected $gtin = '';

    /**
     * gtin
     *
     * @var string
     */
    protected $mpn = '';

    /**
     * pharmacode
     *
     * @var string
     */
    protected $pharmacode = '';

    /**
     * searchString
     *
     * @var string
     */
    protected $searchString = '';

    /**
     * name
     *
     * @var string
     */
    protected $brand = '';

    /**
     * name
     *
     * @var string
     */
    protected $googleProductCategory = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * price
     *
     * @var float
     */
    protected $price;

    /**
     * discount
     *
     * @var float
     */
    protected $discount;

    /**
     * discountStart
     *
     * @var DateTime
     */
    protected $discountStart;

    /**
     * discountEnd
     *
     * @var DateTime
     */
    protected $discountEnd;

    /**
     * priceLabel
     *
     * @var string
     */
    protected $priceLabel;

    /**
     * priceEuro
     *
     * @var float
     */
    protected $priceEuro;

    /**
     * priceMember
     *
     * @var float
     */
    protected $priceMember;

    /**
     * priceMemberEuro
     *
     * @var float
     */
    protected $priceMemberEuro;

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     * @Cascade
     */
    protected $image = null;

    /**
     * imageThumb
     *
     * @var ObjectStorage<FileReference>
     * @Lazy
     */
    protected $imageThumb = null;

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;

    /**
     * noPorto
     *
     * @var boolean
     */
    protected $noPorto = false;

    /**
     * imageThumbTitle
     *
     * @var string
     */
    protected $imageThumbTitle = '';

    /**
     * productInfo
     *
     * @var string
     */
    protected $productInfo = '';

    /**
     * active
     *
     * @var boolean
     */
    protected $onlySwiss = false;

    /**
     * maxAmount
     *
     * @var integer
     */
    protected $maxAmount = 0;

    /**
     * releaseYear
     *
     * @var integer
     */
    protected $releaseYear = 0;

    /**
     * pages
     *
     * @var integer
     */
    protected $pages = 0;

    /**
     * optionsSize
     *
     * @var ObjectStorage<OptionSize>
     * @Lazy
     */
    protected $optionsSize = null;

    /**
     * optionsPackaging
     *
     * @var ObjectStorage<OptionPackaging>
     * @Lazy
     */
    protected $optionsPackaging = null;

    /**
     * category
     *
     * @var ObjectStorage<Category>
     * @Lazy
     */
    protected $category = null;

    /**
     * productClass
     * @var ProductClass
     */
    protected $productClass = null;

    /**
     * optionsColor
     *
     * @var ObjectStorage<OptionColor>
     * @Lazy
     */
    protected $optionsColor = null;

    /**
     * optionEntry
     *
     * @var ObjectStorage<OptionGroup>
     * @Lazy
     */
    protected $optionEntry = null;

    /**
     * optionsInput
     *
     * @var ObjectStorage<OptionInput>
     * @Lazy
     */
    protected $optionsInput = null;

    /**
     * optionsSize
     *
     * @var ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product>
     * @Lazy
     */
    protected $optionsProducts = null;

    /**
     * optionsProductsAmount
     *
     * @var integer
     */
    protected $optionsProductsAmount = 0;

    /**
     * optionEntry
     *
     * @var ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product>
     * @Lazy
     */
    protected $products = null;

    /**
     * prices
     *
     * @var ObjectStorage<Productprice>
     * @Cascade
     * @Lazy
     */
    protected $prices = null;

    /**
     * optionsWithPrice
     *
     * @var ObjectStorage<OptionWithPrice>
     * @Cascade
     * @Lazy
     */
    protected $optionsWithPrice = null;

    /**
     * videos
     *
     * @var ObjectStorage<FileReference>
     * @Cascade
     * @Lazy
     */
    protected $videos = null;

    /**
     * files
     *
     * @var ObjectStorage<FileReference>
     * @Cascade
     * @Lazy
     */
    protected $files = null;

    /**
     * siteId
     *
     * @var int
     */
    protected $siteId = 0;

    /**
     * mandantUid
     *
     * @var int
     */
    protected $mandantUid = 0;



    /**
     * fileRepository
     *
     * @var FileRepository
     */
    protected $fileRepository = null;

    protected int $availability = 1;
    protected ?DateTime $availabilityDate = null;
    protected int $condition = 0;

    /**
     * state
     * @var State
     */
    protected $state = null;

    /**
     * deliveryPeriod
     * @var DeliveryPeriod
     */
    protected $deliveryPeriod = null;

    protected float $width = 0;

    /**
     * height
     *
     * @var double
     */
    protected $height = '';

    /**
     * depth
     *
     * @var double
     */
    protected $depth = '';

    /**
     * weight
     *
     * @var double
     */
    protected $weight = '';

    /**
     * material
     *
     * @var string
     */
    protected $material = '';


    protected ?float $shippingHeight = null;
    protected ?float $shippingWidth = null;
    protected ?float $shippingLength = null;
    protected ?float $shippingWeight = null;
    protected string $shippingLabel = '';

    /**
     * additional
     *
     * @var string
     */
    protected $additional = '';

    /**
     * standardCosts
     *
     * @var double
     */
    protected $standardCosts = 0.0;

    /**
     * priceDescription
     *
     * @var string
     */
    protected $priceDescription = '';

    /**
     * variants
     *
     * @var ObjectStorage<Productvariant>
     * @Lazy
     * @Cascade("remove")
     */
    protected $variants = null;

    /**
     * relatedCategory
     * @var ObjectStorage<Category>
     * @Lazy
     */
    protected $relatedCategory = null;

    /**
     * vergriffen
     * @var boolean
     */
    protected $vergriffen = false;

    protected string $propertiesDescriptionTop = '';

    protected string $propertiesDescriptionBottom = '';

    protected string $containedAccessoriesDescriptionTop = '';

    protected string $containedAccessoriesDescriptionBottom = '';

    protected string $additionalAccessoriesDescriptionTop = '';

    protected string $additionalAccessoriesDescriptionBottom = '';

    protected string $contentDescriptionTop = '';

    protected string $contentDescriptionBottom = '';

    /**
     * @var ObjectStorage<Propertyvalue>
     * @Lazy
     */
    protected ?ObjectStorage $properties = null;

    /**
     * @var ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product>
     * @Lazy
     */
    protected ?ObjectStorage $containedAccessories = null;

    /**
     * @var ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product>
     * @Lazy
     */
    protected ?ObjectStorage $additionalAccessories = null;

    /**
     * contentElementsCols
     * @var int
     */
    protected $contentElementsCols = false;

    /**
     * @var ObjectStorage<\GeorgRinger\News\Domain\Model\TtContent>
     * @Lazy
     */
    protected $contentElements;

    /**
     * productOfMonth
     *
     * @var boolean
     */
    protected $productOfMonth = false;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the productid
     *
     * @return string
     */
    public function getProductid()
    {
        return $this->productid;
    }

    /**
     * Sets the productid
     *
     * @param string $productid
     */
    public function setProductid($productid): void
    {
        $this->productid = $productid;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the brand
     *
     * @return string
     */
    public function getBrand()
    {
        return $this->brand;
    }

    /**
     * Sets the brand
     *
     * @param string $brand
     */
    public function setBrand($brand): void
    {
        $this->brand = $brand;
    }

    /**
     * Returns the gtin
     *
     * @return string
     */
    public function getGtin()
    {
        return $this->gtin;
    }

    /**
     * Sets the gtin
     *
     * @param string $gtin
     */
    public function setGtin($gtin): void
    {
        $this->gtin = $gtin;
    }

    /**
     * Returns the mpn
     *
     * @return string
     */
    public function getMpn()
    {
        return $this->mpn;
    }

    /**
     * Sets the mpn
     *
     * @param string $mpn
     */
    public function setMpn($mpn): void
    {
        $this->mpn = $mpn;
    }

    /**
     * Returns the pharmacode
     *
     * @return string
     */
    public function getPharmacode()
    {
        return $this->pharmacode;
    }

    /**
     * Sets the pharmacode
     *
     * @param string $pharmacode
     */
    public function setPharmacode($pharmacode): void
    {
        $this->pharmacode = $pharmacode;
    }

    /**
     * Sets the searchString
     *
     * @param string $searchString
     */
    public function setSearchString($searchString): void
    {
        $this->searchString = $searchString;
    }

    /**
     * Returns the searchString
     *
     * @return string
     */
    public function getSearchString()
    {
        return $this->searchString;
    }

    /**
     * Returns the googleProductCategory
     *
     * @return string
     */
    public function getGoogleProductCategory()
    {
        return $this->googleProductCategory;
    }

    /**
     * Sets the googleProductCategory
     *
     * @param string $googleProductCategory
     */
    public function setGoogleProductCategory($googleProductCategory): void
    {
        $this->googleProductCategory = $googleProductCategory;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getProductInfo()
    {
        return $this->productInfo;
    }

    /**
     * Sets the ProductInfo
     *
     * @param string $productInfo
     */
    public function setProductInfo($productInfo): void
    {
        $this->productInfo = $productInfo;
    }

    /**
     * Returns the imageThumbTitle
     *
     * @return string
     */
    public function getImageThumbTitle()
    {
        return $this->imageThumbTitle;
    }

    /**
     * Sets the imageTitle
     *
     * @param string $imageThumbTitle
     */
    public function setImageThumbTitle($imageThumbTitle): void
    {
        $this->imageThumbTitle = $imageThumbTitle;
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the discount
     *
     * @return float
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Returns the discount
     */
    public function setDiscount($discount): void
    {
        $this->discount = $discount;
    }

    /**
     * Returns the discountStart
     *
     * @return DateTime
     */
    public function getDiscountStart()
    {
        return $this->discountStart;
    }

    public function setDiscountStart(?DateTime $discountStart): void
    {
        $this->discountStart = $discountStart;
    }

    /**
     * Returns the discountEnd
     *
     * @return DateTime
     */
    public function getDiscountEnd()
    {
        return $this->discountEnd;
    }

    public function setDiscountEnd(?DateTime $discountEnd): void
    {
        $this->discountEnd = $discountEnd;
    }

    /**
     * Returns the priceEuro
     *
     * @return float
     */
    public function getPriceEuro()
    {
        return $this->priceEuro;
    }

    /**
     * Sets the priceEuro
     *
     * @param float $priceEuro
     */
    public function setPriceEuro($priceEuro): void
    {
        $this->priceEuro = $priceEuro;
    }

    /**
     * Returns the priceMember
     *
     * @return float
     */
    public function getPriceMember()
    {
        return $this->priceMember;
    }

    public function getHasPriceMember()
    {
        if ($this->priceMember === null) {
            return false;
        }

        return true;
    }

    /**
     * Sets the priceMember
     *
     * @param float $priceMember
     */
    public function setPriceMember($priceMember): void
    {
        $this->priceMember = $priceMember;
    }

    /**
     * Returns the priceMemberEuro
     *
     * @return float
     */
    public function getPriceMemberEuro()
    {
        return $this->priceMemberEuro;
    }

    /**
     * Sets the priceMemberEuro
     *
     * @param float $priceMemberEuro
     */
    public function setPriceMemberEuro($priceMemberEuro): void
    {
        $this->priceMemberEuro = $priceMemberEuro;
    }

    /**
     * Returns the SiteId
     *
     * @return integer
     */
    public function getSiteId()
    {
        return $this->siteId;
    }

    public function getDetailPageUid(): ?int
    {
        return $this->siteId;
    }

    /**
     * Sets the SiteId
     */
    public function setSiteId($siteId): void
    {
        $this->siteId = $siteId;
    }


    /**
     * Returns the MandantUid
     *
     * @return integer
     */
    public function getMandantUid()
    {
        return $this->mandantUid;
    }

    /**
     * Sets the MandantUid
     */
    public function setMandantUid($mandantUid): void
    {
        $this->mandantUid = $mandantUid;
    }


    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Returns the imageLocalized
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImageLocalized()
    {
        //return $this->getImage();
        return $this->getLocalized('image');
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        $imgs = $this->getImageLocalized();
        return count($imgs) > 0 ? $imgs[0] : null;
    }


    /**
     * Sets the image
     *
     * @param ObjectStorage<FileReference> $image
     */
    public function setImage(ObjectStorage $image): void
    {
        $this->image = $image;
    }

    /**
     * Adds a FileReference
     */
    public function addImageThumb(FileReference $imageThumb): void
    {
        $this->image->attach($imageThumb);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageThumbToRemove The FileReference to be removed
     */
    public function removeImageThumb(FileReference $imageThumbToRemove): void
    {
        $this->image->detach($imageThumbToRemove);
    }

    /**
     * Returns the imageThumb
     *
     * @return ObjectStorage<FileReference> $imageThumb
     */
    public function getImageThumb()
    {
        return $this->imageThumb;
    }

    /**
     * Returns the thumbImageLocalized
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImageThumbLocalized()
    {
        //return $this->getImageThumb();
        return $this->getLocalized('image_thumb');
    }


    /**
     * Sets the imageThumb
     *
     * @param ObjectStorage<FileReference> $imageThumb
     */
    public function setImageThumb(ObjectStorage $imageThumb): void
    {
        $this->imageThumb = $imageThumb;
    }

    /**
     * Adds a FileReference
     */
    public function addFiles(FileReference $files): void
    {
        $this->files->attach($files);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $filesToRemove The FileReference to be removed
     */
    public function removeFiles(FileReference $filesToRemove): void
    {
        $this->image->detach($filesToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getFiles()
    {
        return $this->files;
    }

    /**
     * Sets the files
     *
     * @param ObjectStorage<FileReference> $files
     */
    public function setFiles(ObjectStorage $files): void
    {
        $this->files = $files;
    }

    /**
     * Returns the noPorto
     *
     * @return boolean
     */
    public function getNoPorto()
    {
        return $this->noPorto;
    }

    /**
     * Sets the noPorto
     *
     * @param boolean $noPorto
     */
    public function setNoPorto($noPorto): void
    {
        $this->noPorto = $noPorto;
    }

    /**
     * Returns the boolean state of noPorto
     *
     * @return boolean
     */
    public function isNoPorto()
    {
        return $this->noPorto;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Returns the maxAmount
     *
     * @return integer
     */
    public function getMaxAmount()
    {
        return $this->maxAmount;
    }

    /**
     * Sets the maxAmount
     *
     * @param integer $maxAmount
     */
    public function setMaxAmount($maxAmount): void
    {
        $this->maxAmount = $maxAmount;
    }

    /**
     * Returns the pages
     *
     * @return integer
     */
    public function getPages()
    {
        return $this->pages;
    }

    /**
     * Sets the pages
     *
     * @param integer $pages
     */
    public function setpages($pages): void
    {
        $this->pages = $pages;
    }

    /**
     * Returns the releaseYear
     *
     * @return integer
     */
    public function getReleaseYear()
    {
        return $this->releaseYear;
    }

    /**
     * Sets the releaseYear
     *
     * @param integer $releaseYear
     */
    public function setReleaseYear($releaseYear): void
    {
        $this->releaseYear = $releaseYear;
    }

    /**
     * Adds a OptionSize
     */
    public function addOptionsSize(OptionSize $optionsSize): void
    {
        $this->optionsSize->attach($optionsSize);
    }

    /**
     * Removes a OptionSize
     *
     * @param OptionSize $optionsSizeToRemove The OptionSize to be removed
     */
    public function removeOptionsSize(OptionSize $optionsSizeToRemove): void
    {
        $this->optionsSize->detach($optionsSizeToRemove);
    }

    /**
     * Returns the optionsSize
     *
     * @return ObjectStorage<OptionSize> $optionsSize
     */
    public function getOptionsSize()
    {
        return $this->optionsSize;
    }

    /**
     * Sets the optionsSize
     *
     * @param ObjectStorage<OptionSize> $optionsSize
     */
    public function setOptionsSize(ObjectStorage $optionsSize): void
    {
        $this->optionsSize = $optionsSize;
    }

    /**
     * Adds a OptionPackaging
     */
    public function addOptionsPackaging(OptionPackaging $optionsPackaging): void
    {
        $this->optionsPackaging->attach($optionsPackaging);
    }

    /**
     * Removes a OptionPackaging
     *
     * @param OptionPackaging $optionsPackagingToRemove The OptionPackaging to be removed
     */
    public function removeOptionsPackaging(
        OptionPackaging $optionsPackagingToRemove
    ): void {
        $this->optionsPackaging->detach($optionsPackagingToRemove);
    }

    /**
     * Returns the optionsPackaging
     *
     * @return ObjectStorage<OptionPackaging> $optionsPackaging
     */
    public function getOptionsPackaging()
    {
        return $this->optionsPackaging;
    }

    /**
     * Sets the optionsPackaging
     *
     * @param ObjectStorage<OptionPackaging> $optionsPackaging
     */
    public function setOptionsPackaging(ObjectStorage $optionsPackaging): void
    {
        $this->optionsPackaging = $optionsPackaging;
    }

    /**
     * Adds a Product
     */
    public function addProduct(self $product): void
    {
        $this->products->attach($product);
    }

    /**
     * Removes a product
     *
     * @param \InternetGalerie\Igshop2\Domain\Model\Product $product The Product to be removed
     */
    public function removeProduct(self $product): void
    {
        $this->products->detach($product);
    }

    /**
     * Returns the products
     *
     * @return ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product> $product
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * Sets the producuts
     *
     * @param ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product> $products
     */
    public function setProducts(ObjectStorage $products): void
    {
        $this->products = $products;
    }

    /**
     * Adds a Category
     */
    public function addCategory(Category $category): void
    {
        $this->category->attach($category);
    }

    /**
     * Removes a Category
     *
     * @param Category $categoryToRemove The Category to be removed
     */
    public function removeCategory(Category $categoryToRemove): void
    {
        $this->category->detach($categoryToRemove);
    }

    /**
     * Returns the category
     *
     * @return ObjectStorage<Category> $category
     */
    public function getCategory()
    {
        return $this->category;
    }

    public function getCategoryFirst()
    {
        foreach ($this->getCategory() as $category) {
            if (!$category->isExcludeSlug()) {
                return $category;
            }
        }

        return null;
    }

    public function getCategoryDetailPageUid()
    {
        $category = $this->getCategoryFirst();
        return $category ? $category->getDetailPageUid() : null;
    }

    public function hasCategoryIn(array $categoryUids)
    {
        foreach ($this->category as $category) {
            if (in_array($category->getUid(), $categoryUids)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Sets the category
     *
     * @param ObjectStorage<Category> $category
     */
    public function setCategory(ObjectStorage $category): void
    {
        $this->category = $category;
    }

    /**
     * Returns the productClass
     *
     * @return ProductClass
     */
    public function getProductClass()
    {
        return $this->productClass;
    }

    /**
     * Sets the productClass
     */
    public function setProductClass(ProductClass $productClass): void
    {
        $this->productClass = $productClass;
    }

    /**
     * Returns the first Top level category otherwise the top level category of the first category
     *
     * @return ObjectStorage<Category> $category
     */
    public function getCategoryTopLevel()
    {
        foreach ($this->getCategory() as $cat) {
            if ($cat->getParent() == 0 && $cat->getExcludeSlug() == 0) {
                return $cat;
            }
        }

        foreach ($this->getCategory() as $cat) {
            $p = $cat->getParent();
            if ($p && $p->getParent() == 0) {
                return $p;
            }
        }

        return null;
    }

    public function getFirstCategoryTopLevel()
    {
        if ($this->getCategory()->count() > 0) {
            foreach ($this->getCategory() as $category) {
                if ($category->isExcludeSlug()) {
                    continue;
                }

                $topCategory = $category->getTopCategory();
                if (!$topCategory->isExcludeSlug()) {
                    return $topCategory;
                }
            }
        } else {
            return null;
        }

        /*

        if(!$category && $this->getCategory()) {
            $category = $this->getCategory()[0];
        } else if(!$category) {
            return null;
        }

        $parent = $category->getParent();

        if($parent) {
            return $this->getFirstCategoryTopLevel($parent);
        }

        return $category;
        */
    }


    /**
     * Adds a OptionColor
     */
    public function addOptionsColor(OptionColor $optionsColor): void
    {
        $this->optionsColor->attach($optionsColor);
    }

    /**
     * Removes a OptionColor
     *
     * @param OptionColor $optionsColorToRemove The OptionColor to be removed
     */
    public function removeOptionsColor(OptionColor $optionsColorToRemove): void
    {
        $this->optionsColor->detach($optionsColorToRemove);
    }

    /**
     * Returns the optionsColor
     *
     * @return ObjectStorage<OptionColor> $optionsColor
     */
    public function getOptionsColor()
    {
        return $this->optionsColor;
    }

    /**
     * Sets the optionsColor
     *
     * @param ObjectStorage<OptionColor> $optionsColor
     */
    public function setOptionsColor(ObjectStorage $optionsColor): void
    {
        $this->optionsColor = $optionsColor;
    }


    /**
     * Adds a Product
     */
    public function addOptionsProduct(self $product): void
    {
        $this->optionsProducts->attach($product);
    }

    /**
     * Removes a Product
     *
     * @param \InternetGalerie\Igshop2\Domain\Model\Product $productToRemove The OptionColor to be removed
     */
    public function removeOptionsProduct(self $productToRemove): void
    {
        $this->optionsProducts->detach($productToRemove);
    }

    /**
     * Returns the optionsProducts
     *
     * @return ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product> $optionsProducts
     */
    public function getOptionsProducts()
    {
        return $this->optionsProducts;
    }

    /**
     * Sets the optionsProducts
     *
     * @param ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product> $optionsProducts
     */
    public function setOptionsProducts(ObjectStorage $optionsProducts): void
    {
        $this->optionsProducts = $optionsProducts;
    }

    /**
     * Adds a OptionGroup
     */
    public function addOptionEntry(OptionGroup $optionEntry): void
    {
        $this->optionEntry->attach($optionEntry);
    }

    /**
     * Removes a OptionGroup
     *
     * @param OptionGroup $optionEntryToRemove The OptionGroup to be removed
     */
    public function removeOptionEntry(OptionGroup $optionEntryToRemove): void
    {
        $this->optionEntry->detach($optionEntryToRemove);
    }

    /**
     * Returns the optionEntry
     *
     * @return ObjectStorage<OptionGroup> $optionEntry
     */
    public function getOptionEntry()
    {
        return $this->optionEntry;
    }

    /**
     * Sets the optionEntry
     *
     * @param ObjectStorage<OptionGroup> $optionEntry
     */
    public function setOptionEntry(ObjectStorage $optionEntry): void
    {
        $this->optionEntry = $optionEntry;
    }

    /**
     * Adds a Productprice
     */
    public function addPrice(Productprice $price): void
    {
        $this->prices->attach($price);
    }

    /**
     * Removes a Productprice
     *
     * @param Productprice $priceToRemove The Productprice to be removed
     */
    public function removePrice(Productprice $priceToRemove): void
    {
        $this->prices->detach($priceToRemove);
    }

    /**
     * Returns the prices
     *
     * @return ObjectStorage<Productprice> $prices
     */
    public function getPrices()
    {
        return $this->prices;
    }

    public function getPricesSortByAmount()
    {
        $prices = $this->prices->toArray();
        usort($prices, static fn ($a, $b) => $a->getAmount() - $b->getAmount());
        return $prices;
    }

    public function getPricesHasDiscount()
    {
        foreach ($this->prices as $price) {
            if ($price->getAmount() <= 1) {
                return true;
            }
        }

        return false;
    }

    public function getPricesHasQuantityDiscount()
    {
        foreach ($this->prices as $price) {
            if ($price->getAmount() > 1) {
                return true;
            }
        }

        return false;
    }

    /**
     * Sets the prices
     *
     * @param ObjectStorage<Productprice> $prices
     */
    public function setPrices(ObjectStorage $prices): void
    {
        $this->prices = $prices;
    }

    /**
     * Adds a OptionWithPrice
     */
    public function addOptionsWithPrice(OptionWithPrice $optionsWithPrice): void
    {
        $this->optionsWithPrice->attach($optionsWithPrice);
    }

    /**
     * Removes a OptionWithPrice
     *
     * @param OptionWithPrice $optionsWithPriceToRemove The OptionWithPrice to be removed
     */
    public function removeOptionsWithPrice(
        OptionWithPrice $optionsWithPriceToRemove
    ): void {
        $this->optionsWithPrice->detach($optionsWithPriceToRemove);
    }

    /**
     * Returns the optionsWithPrice
     *
     * @return ObjectStorage<OptionWithPrice> $optionsWithPrice
     */
    public function getOptionsWithPrice()
    {
        return $this->optionsWithPrice;
    }

    /**
     * Returns the optionsWithPriceLocalized
     *
     * @return ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\OptionSizePrice> $optionsWithPriceLocalized
     */
    public function getOptionsWithPriceLocalized()
    {
        // eigentlich müsste man das TCA anpassen -> https://docs.typo3.org/typo3cms/TCAReference/Reference/Columns/Inline/Index.html#behaviour  localizationMode showSynchronizationLink =1
        /*
"behaviour" => array (
  "localizationMode" => "select"
)
      */
        $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
            'language',
            'id'
        ) > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();
        $optionWithPriceRepository = GeneralUtility::makeInstance(OptionWithPriceRepository::class);
        if ($this->resOptionSizePrice === null) {
            $this->resOptionSizePrice = $optionWithPriceRepository->findByProduct($uidLang);
        }

        return $this->resOptionSizePrice;
    }

    public function getOptionsWithPriceAll()
    {
        // eigentlich müsste man das TCA anpassen -> https://docs.typo3.org/typo3cms/TCAReference/Reference/Columns/Inline/Index.html#behaviour  localizationMode showSynchronizationLink =1
        /*
"behaviour" => array (
  "localizationMode" => "select"
)
      */
        //$uidLang =  GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id') > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();

        // get all uids
        $uidList = [];
        $uidList[] = $this->getUid();
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igshop2_domain_model_product'
        );
        $res = $queryBuilder->select('uid')
        ->from('tx_igshop2_domain_model_product')
        ->where($queryBuilder->expr()->and(
            $queryBuilder->expr()
->eq('deleted', $queryBuilder->createNamedParameter('0')),
            $queryBuilder->expr()
->eq('hidden', $queryBuilder->createNamedParameter('0')),
            $queryBuilder->expr()
->eq('l10n_parent', $queryBuilder->createNamedParameter(intval($this->getUid())))
        ))->executeQuery();
        //$res=$GLOBALS['TYPO3_DB']->exec_SELECTquery('uid','tx_igshop2_domain_model_product', 'deleted=0 AND hidden=0 AND l10n_parent= ' . intval($this->getUid()));
        //if( ( $d = $GLOBALS['TYPO3_DB']->sql_fetch_assoc( $res ))) {
        if (($d = $res->fetchAssociative())) {
            $uidList[] = $d['uid'];
        }

        //print_r($uidList);
        //$productRepository = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('InternetGalerie\Igshop2\Domain\Repository\ProductRepository');
        //$uidList= $productRepository->findUidList($this->getUid());
        //$e= $uidList->getFirst();
        //$uid_lang=$e->_getProperty('_localizedUid');
        $this->resOptionSizePrice = [];
        //      if($this->resOptionSizePrice===null) {
        //$this->resOptionSizePrice= $this->optionWithPriceRepository->findByProduct( $uidLang);
        $optionWithPriceRepository = GeneralUtility::makeInstance(OptionWithPriceRepository::class);
        foreach ($uidList as $c => $uid) {
            foreach ($optionWithPriceRepository->findByProduct($uid) as $p) {
                $this->resOptionSizePrice[] = $p;
            }
        }

        return $this->resOptionSizePrice;
    }

    /**
     * Sets the optionsWithPrice
     *
     * @param ObjectStorage<OptionWithPrice> $optionsWithPrice
     */
    public function setOptionsWithPrice(ObjectStorage $optionsWithPrice): void
    {
        $this->optionsWithPrice = $optionsWithPrice;
    }

    public function addVideo(FileReference $video): void
    {
        $this->videos->attach($video);
    }

    public function removeVideo(FileReference $videoToRemove): void
    {
        $this->videos->detach($videoToRemove);
    }

    public function getVideos(): ObjectStorage
    {
        return $this->videos;
    }

    public function setVideos(ObjectStorage $videos): void
    {
        $this->videos = $videos;
    }

    public function hasActionPrice($currency)
    {
        return is_array($this->getFinalPrice($currency, null, 0, true));
    }

    /**
     * Returns the onlySwiss
     *
     * @return boolean
     */
    public function getOnlySwiss()
    {
        return $this->onlySwiss;
    }

    /**
     * Sets the onlySwiss
     *
     * @param boolean $onlySwiss
     */
    public function setOnlySwiss($onlySwiss): void
    {
        $this->onlySwiss = $onlySwiss;
    }

    /**
     * Returns the boolean state of onlySwiss
     *
     * @return boolean
     */
    public function isOnlySwiss()
    {
        return $this->onlySwiss;
    }

    /**
     * Returns the correct price, if there is set a special price order the customer is a member
     * @param Currency $currency
     * @param int $optionWithPriceUid
     * @param int $amount
     * @param boolean $checkForPromotion
     * @return float
     */
    public function getFinalPrice(
        $currency,
        $optionWithPriceUid = null,
        $amount = 0,
        $checkForPromotion = false,
        $isMember = false
    ) {
        if ($this->onlySwiss && $currency->getShort() != 'CHF') {
            return null;
        }

        $context = GeneralUtility::makeInstance(Context::class);

        $memberGroups = $context->getPropertyFromAspect('frontend.user', 'groupIds');
        $prices = [];
        // Finde den Normalpreis (nicht eingeloggt od. eingeloggt, EuroPreis od. andere Währung)
        $prices[] = $this -> getDefaultPrices($memberGroups, $currency, $isMember);
        //Preise nach Optionen, welche einen Preis beinhalten
        if ($this->optionsWithPrice && $optionWithPriceUid > 0) {
            foreach ($this->optionsWithPrice as $optionWithPrice) {
                $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
                    'language',
                    'id'
                ) > 0 ? $optionWithPrice->_getProperty('_localizedUid') : $optionWithPrice->getUid();

                //echo('[('.$this->getUid().')'.$optionWithPriceUid.'=='.$optionWithPrice->getUid().'=='.$uidLang.']');
                if ($optionWithPrice->getUid() == $optionWithPriceUid) {
                    return $optionWithPrice->getOptionPrice($currency, $amount);
                }
            }
        }

        // Finde alle PreisOptionen, die zutreffen
        $optionalPrices = $this->getPossibleOptionalPrices($currency, $memberGroups);

        // Wenn Mengenrabatt, filtere aus
        if ($amount > 0) {
            $quantityDiscountPrice = $this->getQuantitydiscountPrice($optionalPrices, $amount, $currency);
            if ($quantityDiscountPrice > 0) {
                $prices[] = $quantityDiscountPrice;
            }
        }

        $isActionPrice = false;
        foreach ($optionalPrices as $price) {
            if ($price->isIsSpecialPrice()) {
                if ($this->takeEuroPrice($currency->getShort(), $price->getPriceEuro())) {
                    if (min($prices) > $price->getEuroPrice) {
                        $isActionPrice = true;
                    }

                    $prices[] = $price->getPriceEuro();
                } else {
                    if (min($prices) > $price->getPrice() * $currency->getFaktor()) {
                        $isActionPrice = true;
                    }

                    $prices[] = $price->getPrice() * $currency->getFaktor();
                }
            }
        }

        // Add discount
        $discount = $this->getDiscount();
        $discountStart = $this->getDiscountStart();
        if ($discountStart) {
            $discountStart->setTime(0, 0, 0);
        }

        $discountEnd = $this->getDiscountEnd();
        if ($discountEnd) {
            $discountEnd->setTime(23, 59, 59);
        }

        $now = new DateTime();

        if ($discount && (($discountStart && $discountStart <= $now) || !$discountStart) && (($discountEnd && $discountEnd >= $now) || !$discountEnd)) {
            $discountedPrice = 0;
            if ($this->takeEuroPrice($currency->getShort(), $this->getPriceEuro())) {
                $discountedPrice = $this->getPriceEuro();
            } else {
                $discountedPrice = $this->getPrice() * $currency->getFaktor();
            }

            $discountDecimal = $discount * 0.01;
            $discountAmount = $discountedPrice * $discountDecimal;
            $discountedPrice -= $discountAmount;
            if (min($prices) > $discountedPrice) {
                $isActionPrice = true;
            }

            $prices[] = $discountedPrice;
        }

        if ($checkForPromotion && $isActionPrice) {
            $origPrice = 0;
            if ($this->getPriceEuro()) {
                $origPrice = $this -> priceEuro;
            } else {
                $origPrice = $this -> price * $currency->getFaktor();
            }

            return [
                'price' => min($prices),
                'state' => 'isPromotion',
                'origPrice' => $origPrice,
            ];
        }

        return min($prices);
    }

    /**
     * @param int $_languageUid
     */
    public function set_languageUid($_languageUid): void
    {
        $this->_languageUid = $_languageUid;
    }

    /**
     * @return int
     */
    public function get_languageUid()
    {
        return $this->_languageUid;
    }

    /**
     * @param int $_localizedUid
     */
    public function set_localizedUid($_localizedUid): void
    {
        $this->_localizedUid = $_localizedUid;
    }

    /**
     * @return int
     */
    public function get_localizedUid()
    {
        return $this->_localizedUid;
    }

    public function getAvailability(): int
    {
        return $this->availability;
    }
    public function getIsAvailable(): bool
    {
        return $this->availability > 0;
    }
    /**
     * google merchant export availability value according:
     * https://support.google.com/merchants/answer/6324448?hl=en
     */
    public function getAvailabilityForGoogle(): string
    {
        return match ($this->availability) {
            0 => 'out of stock',
            2 => 'preorder',
            3 => 'backorder',
            default => 'in stock',
        };
    }
    public function getAvailabilityKey(): string
    {
        return match ($this->availability) {
            0 => 'out_of_stock',
            2 => 'preorder',
            3 => 'backorder',
            default => 'in_stock',
        };
    }
    public function getAvailabilityText(): string
    {
        $key = 'availability.' . $this->getAvailabilityKey();
        return LocalizationUtility::translate($key, 'Igshop2');
    }
    
    public function setAvailability(int $availability): void
    {
        $this->availability = $availability;
    }

    public function getAvailabilityDate(): ?DateTime
    {
        if ($this->availability === 2 || $this->availability === 3) {
            return $this->availabilityDate;
        }
        return null;
    }

    public function setAvailabilityDate(?DateTime $availabilityDate): void
    {
        $this->availabilityDate = $availabilityDate;
    }

    
    public function getCondition(): int
    {
        return $this->condition;
    }

    /**
     * google merchant export condition value according:
     * https://support.google.com/merchants/answer/6324469?sjid=13126148581946228534-EU&visit_id=638445583491386227-1499873896&rd=1
     */
    public function getConditionForGoogle(): string
    {
        return match ($this->condition) {
            1 => 'refurbished',
            2 => 'used',
            default => 'new',
        };
    }

    public function setCondition(int $condition): void
    {
        $this->condition = $condition;
    }

    /**
     * @return State
     */
    public function getState()
    {
        return $this->state;
    }


    public function setState(State $state): void
    {
        $this->state = $state;
    }

    /**
     * @return DeliveryPeriod
     */
    public function getDeliveryPeriod()
    {
        return $this->deliveryPeriod;
    }


    public function setDeliveryPeriod($deliveryPeriod): void
    {
        $this->deliveryPeriod = $deliveryPeriod;
    }

    public function getWidth(): float
    {
        return $this->width;
    }

    public function setWidth(float $width): void
    {
        $this->width = $width;
    }

    /**
     * @return double
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @param double $height
     */
    public function setHeight($height): void
    {
        $this->height = $height;
    }

    /**
     * @return double
     */
    public function getDepth()
    {
        return $this->depth;
    }

    /**
     * @param double $depth
     */
    public function setDepth($depth): void
    {
        $this->depth = $depth;
    }

    /**
     * @return double
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * @param double $weight
     */
    public function setWeight($weight): void
    {
        $this->weight = $weight;
    }

    public function getHasInfoTable()
    {
        return $this->weight || $this->width || $this->height || $this->depth;
    }

    public function getShippingWidth(): ?float
    {
        return $this->shippingWidth;
    }

    public function setShippingWidth(?float $shippingWidth): void
    {
        $this->shippingWidth = $shippingWidth;
    }

    public function getShippingHeight(): ?float
    {
        return $this->shippingHeight;
    }

    public function setShippingHeight(?float $shippingHeight): void
    {
        $this->shippingHeight = $shippingHeight;
    }

    public function getShippingLength(): ?float
    {
        return $this->shippingLength;
    }

    public function setShippingLength(?float $shippingLength): void
    {
        $this->shippingLength = $shippingLength;
    }

    public function getShippingWeight(): ?float
    {
        return $this->shippingWeight;
    }

    public function setShippingWeight(?float $shippingWeight): void
    {
        $this->shippingWeight = $shippingWeight;
    }

    public function getShippingLabel(): string
    {
        return $this->shippingLabel;
    }

    public function setShippingLabel(string $shippingLabel): void
    {
        $this->shippingLabel = $shippingLabel;
    }

    
    /**
     * Get the value of material
     *
     * @return string
     */
    public function getMaterial()
    {
        return $this->material;
    }

    /**
     * Set the value of material
     *
     * @param string $material
     *
     * @return self
     */
    public function setMaterial($material)
    {
        $this->material = $material;

        return $this;
    }

    /**
     * Get the value of additional
     *
     * @return string
     */
    public function getAdditional()
    {
        return $this->additional;
    }

    /**
     * Set the value of additional
     *
     * @param string $additional
     *
     * @return self
     */
    public function setAdditional($additional)
    {
        $this->additional = $additional;

        return $this;
    }

    /**
     * Get the value of standardCosts
     *
     * @return double
     */
    public function getStandardCosts()
    {
        return $this->standardCosts;
    }

    /**
     * Set the value of standardCosts
     *
     * @param double $standardCosts
     *
     * @return self
     */
    public function setStandardCosts($standardCosts)
    {
        $this->standardCosts = $standardCosts;

        return $this;
    }

    /**
     * Returns the priceDescription
     *
     * @return string
     */
    public function getPriceDescription()
    {
        return $this->priceDescription;
    }

    /**
     * Sets the priceDescription
     *
     * @param string $priceDescription
     */
    public function setPriceDescription($priceDescription): void
    {
        $this->priceDescription = $priceDescription;
    }

    /**
     * Adds a Productvariant
     */
    public function addVariant(Productvariant $variant): void
    {
        $this->variants->attach($variant);
    }

    /**
     * Removes a Productvariant
     *
     * @param Productvariant $variantToRemove The Productvariant to be removed
     */
    public function removeVariant(Productvariant $variantToRemove): void
    {
        $this->variants->detach($variantToRemove);
    }

    /**
     * Returns the variants
     *
     * @return ObjectStorage<Productvariant> $variants
     */
    public function getVariants()
    {
        return $this->variants;
    }

    /**
     * Sets the variants
     *
     * @param ObjectStorage<Productvariant> $variants
     */
    public function setVariants(ObjectStorage $variants): void
    {
        $this->variants = $variants;
    }

    public function getRelatedProducts()
    {
        $relatedProducts = [];
        foreach ($this->getCategory() as $category) {
            if ($category->isExcludeSlug()) {
                continue;
            }

            foreach ($category->getProducts() as $product) {
                $relatedProducts[] = $product;
            }
        }

        return $relatedProducts;
    }

    /**
     * Get the value of relatedCategory
     *
     * @return ObjectStorage<Category> $relatedCategory
     */
    public function getRelatedCategory()
    {
        return $this->relatedCategory;
    }

    /**
     * Set the value of relatedCategory
     *
     * @param ObjectStorage<Category> $relatedCategory
     *
     * @return self
     */
    public function setRelatedCategory(ObjectStorage $relatedCategory)
    {
        $this->relatedCategory = $relatedCategory;

        return $this;
    }

    /**
     * Adds a relatedCategory
     */
    public function addRelatedCategory(Category $relatedCategory): void
    {
        $this->relatedCategory->attach($relatedCategory);
    }

    /**
     * Removes a relatedCategory
     *
     * @param Category $relatedCategory The Category to be removed
     */
    public function removeRelatedCategory(Category $relatedCategory): void
    {
        $this->relatedCategory->detach($relatedCategory);
    }


    /**
     * Get the value of optionWithPriceRepository
     *
     * @return ObjectStorage<OptionWithPrice>
     */
    public function getResOptionSizePrice()
    {
        return $this->resOptionSizePrice;
    }


    /**
     * Get the value of priceLabel
     *
     * @return string
     */
    public function getPriceLabel()
    {
        return $this->priceLabel;
    }

    /**
     * Set the value of priceLabel
     *
     * @param string $priceLabel
     *
     * @return self
     */
    public function setPriceLabel($priceLabel)
    {
        $this->priceLabel = $priceLabel;

        return $this;
    }


    /**
     * Get the value of optionsInput
     *
     * @return ObjectStorage<OptionInput>
     */
    public function getOptionsInput()
    {
        return $this->optionsInput;
    }

    /**
     * Set the value of optionsInput
     *
     * @param ObjectStorage<OptionInput> $optionsInput
     *
     * @return self
     */
    public function setOptionsInput(ObjectStorage $optionsInput)
    {
        $this->optionsInput = $optionsInput;

        return $this;
    }



    /**
     * Adds a OptionSize
     */
    public function addOptionsInput(OptionInput $optionsInput): void
    {
        $this->optionsInput->attach($optionsInput);
    }

    /**
     * Removes a OptionSize
     */
    public function removeOptionsInput(OptionInput $optionsInputToRemove): void
    {
        $this->optionsInput->detach($optionsInputToRemove);
    }


    /**
     * Get the value of vergriffen
     *
     * @return boolean
     */
    public function getVergriffen()
    {
        return $this->vergriffen;
    }

    /**
     * Set the value of vergriffen
     *
     * @param boolean $vergriffen
     *
     * @return self
     */
    public function setVergriffen($vergriffen)
    {
        $this->vergriffen = $vergriffen;

        return $this;
    }


    /**
     * Get the value of optionsProductsAmount
     *
     * @return integer
     */
    public function getOptionsProductsAmount()
    {
        return $this->optionsProductsAmount;
    }

    /**
     * Set the value of optionsProductsAmount
     *
     * @param integer $optionsProductsAmount
     *
     * @return self
     */
    public function setOptionsProductsAmount($optionsProductsAmount)
    {
        $this->optionsProductsAmount = $optionsProductsAmount;

        return $this;
    }

    public function setProperties(ObjectStorage $properties): void
    {
        $this->properties = $properties;
    }

    public function getProperties(): ?ObjectStorage
    {
        return $this->properties;
    }

    public function addProperty(Property $property): void
    {
        $this->properties->attach($property);
    }

    public function hasProperty(Property $property)
    {
        return $this->properties->contains($property);
    }

    public function removeProperty(Property $property): void
    {
        $this->properties->detach($property);
    }

    public function setContainedAccessories(ObjectStorage $containedAccessories): void
    {
        $this->containedAccessories = $containedAccessories;
    }

    public function getContainedAccessories(): ?ObjectStorage
    {
        return $this->containedAccessories;
    }

    public function addContainedAccessory(self $containedAccessory): void
    {
        $this->containedAccessories->attach($containedAccessory);
    }

    public function hasContainedAccessory(self $containedAccessory)
    {
        return $this->containedAccessories->contains($containedAccessory);
    }

    public function removeContainedAccessory(self $containedAccessory): void
    {
        $this->containedAccessories->detach($containedAccessory);
    }

    public function setAdditionalAccessories(ObjectStorage $additionalAccessories): void
    {
        $this->additionalAccessories = $additionalAccessories;
    }

    public function getAdditionalAccessories(): ?ObjectStorage
    {
        return $this->additionalAccessories;
    }

    public function addAdditionalAccessory(self $additionalAccessory): void
    {
        $this->additionalAccessories->attach($additionalAccessory);
    }

    public function hasAdditionalAccessory(self $additionalAccessory)
    {
        return $this->additionalAccessories->contains($additionalAccessory);
    }

    public function removeAdditionalAccessory(self $additionalAccessory): void
    {
        $this->additionalAccessories->detach($additionalAccessory);
    }


    /**
     * Get the value of productOfMonth
     *
     * @return boolean
     */
    public function getProductOfMonth()
    {
        return $this->productOfMonth;
    }

    /**
     * Set the value of productOfMonth
     *
     * @param boolean $productOfMonth
     *
     * @return self
     */
    public function setProductOfMonth($productOfMonth)
    {
        $this->productOfMonth = $productOfMonth;

        return $this;
    }

    public function getImageAndVideoCount()
    {
        return (int)$this->image->count() + (int)$this->videos->count();
    }

    public function getContentElementsCols(): int
    {
        return $this->contentElementsCols;
    }

    public function setContentElementsCols(int $contentElementsCols): void
    {
        $this->contentElementsCols = $contentElementsCols;
    }

    /**
     * Get content elements
     */
    public function getContentElements(): ?ObjectStorage
    {
        return $this->contentElements;
    }

    /**
     * Set content element list
     *
     * @param ObjectStorage $contentElements content elements
     */
    public function setContentElements($contentElements): void
    {
        $this->contentElements = $contentElements;
    }

    /**
     * Adds a content element to the record
     */
    public function addContentElement(TtContent $contentElement): void
    {
        if ($this->getContentElements() === null) {
            $this->contentElements = new ObjectStorage();
        }

        $this->contentElements->attach($contentElement);
    }

    /**
     * Get id list of content elements
     */
    public function getContentElementIdList(): string
    {
        return $this->getIdOfContentElements();
    }

    /**
     * Get translated id list of content elements
     */
    public function getTranslatedContentElementIdList(): string
    {
        return $this->getIdOfContentElements(false);
    }

    public function getPropertiesSortedByCategories(): array
    {
        $propertiesSortedByCategories = [];

        foreach ($this->getCategory() as $category) {
            foreach ($category->getProperties() as $property) {
                foreach ($this->getProperties() as $propertyValue) {
                    if ($propertyValue->getValue() !== null && $propertyValue->getValue() !== '' && $property->getUid() == $propertyValue->getProperty()->getUid()) {
                        $propertiesSortedByCategories[] = $propertyValue;
                    }
                }
            }
        }

        return $propertiesSortedByCategories;
    }

    public function getPropertiesSortedByCategoriesForDetailview(): array
    {
        $propertiesSortedByCategories = [];

        foreach ($this->getCategory() as $category) {
            foreach ($category->getProperties() as $property) {
                foreach ($this->getProperties() as $propertyValue) {
                    if ($propertyValue->getValue() !== null && $propertyValue->getValue() !== '' && $property->getUid() == $propertyValue->getProperty()->getUid()
                       && $propertyValue->getProperty()
->getShowInDetailpage()) {
                        $propertiesSortedByCategories[] = $propertyValue;
                    }
                }
            }
        }
        return $propertiesSortedByCategories;
    }

    public function getPropertiesDescriptionTop(): string
    {
        return $this->propertiesDescriptionTop;
    }

    public function setPropertiesDescriptionTop($propertiesDescriptionTop): void
    {
        $this->propertiesDescriptionTop = $propertiesDescriptionTop;
    }

    public function getPropertiesDescriptionBottom(): string
    {
        return $this->propertiesDescriptionBottom;
    }

    public function setPropertiesDescriptionBottom(string $propertiesDescriptionBottom): void
    {
        $this->propertiesDescriptionBottom = $propertiesDescriptionBottom;
    }

    public function getContainedAccessoriesDescriptionTop(): string
    {
        return $this->containedAccessoriesDescriptionTop;
    }

    /**
     * Set the value of containedAccessoriesDescriptionTop
     *
     * @return  self
     */
    public function setContainedAccessoriesDescriptionTop(string $containedAccessoriesDescriptionTop): void
    {
        $this->containedAccessoriesDescriptionTop = $containedAccessoriesDescriptionTop;
    }

    public function getContainedAccessoriesDescriptionBottom(): string
    {
        return $this->containedAccessoriesDescriptionBottom;
    }

    public function setContainedAccessoriesDescriptionBottom(string $containedAccessoriesDescriptionBottom): void
    {
        $this->containedAccessoriesDescriptionBottom = $containedAccessoriesDescriptionBottom;
    }

    public function getAdditionalAccessoriesDescriptionTop(): string
    {
        return $this->additionalAccessoriesDescriptionTop;
    }

    public function setAdditionalAccessoriesDescriptionTop(string $additionalAccessoriesDescriptionTop): void
    {
        $this->additionalAccessoriesDescriptionTop = $additionalAccessoriesDescriptionTop;
    }

    public function getAdditionalAccessoriesDescriptionBottom(): string
    {
        return $this->additionalAccessoriesDescriptionBottom;
    }

    public function setAdditionalAccessoriesDescriptionBottom(string $additionalAccessoriesDescriptionBottom): void
    {
        $this->additionalAccessoriesDescriptionBottom = $additionalAccessoriesDescriptionBottom;
    }

    public function getContentDescriptionTop(): string
    {
        return $this->contentDescriptionTop;
    }

    public function setContentDescriptionTop(string $contentDescriptionTop): void
    {
        $this->contentDescriptionTop = $contentDescriptionTop;
    }

    public function getContentDescriptionBottom(): string
    {
        return $this->contentDescriptionBottom;
    }

    public function setContentDescriptionBottom(string $contentDescriptionBottom): void
    {
        $this->contentDescriptionBottom = $contentDescriptionBottom;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->image = new ObjectStorage();
        $this->imageThumb = new ObjectStorage();
        $this->optionsSize = new ObjectStorage();
        $this->category = new ObjectStorage();
        $this->relatedCategory = new ObjectStorage();
        $this->products = new ObjectStorage();
        $this->optionsColor = new ObjectStorage();
        $this->optionEntry = new ObjectStorage();
        $this->optionsInput = new ObjectStorage();
        $this->prices = new ObjectStorage();
        $this->optionsWithPrice = new ObjectStorage();
        $this->videos = new ObjectStorage();
        $this->properties = new ObjectStorage();
        $this->containedAccessories = new ObjectStorage();
        $this->additionalAccessories = new ObjectStorage();
    }

    protected function getLocalized($attribute)
    {
        $uidLang = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect(
            'language',
            'id'
        ) > 0 ? $this->_getProperty('_localizedUid') : $this->getUid();

        if ($this->fileRepository === null) {
            $this->fileRepository = GeneralUtility::makeInstance(
                FileRepository::class
            );
        }

        $falTrans = $this->fileRepository->findByRelation('tx_igshop2_domain_model_product', $attribute, $uidLang);
        return $falTrans;
    }

    /**
     * Collect id list
     *
     * @param bool $original
     */
    protected function getIdOfContentElements($original = true): string
    {
        $idList = [];
        $contentElements = $this->getContentElements();
        if ($contentElements !== null) {
            foreach ($this->getContentElements() as $contentElement) {
                if ($contentElement->getColPos() >= 0) {
                    $idList[] = $original ? $contentElement->getUid() : $contentElement->_getProperty('_localizedUid');
                }
            }
        }

        return implode(',', $idList);
    }

    /**
     * Check all Optional Prices if there is a Quantitydiscount an return one
     * @param array $quantityDiscounts
     * @param int $quantity
     * @return Productprice
     */
    private function getQuantitydiscountPrice($quantityDiscounts, $quantity, $currency)
    {
        $quantityDiscountPrice = null;

        foreach ($quantityDiscounts as $key => $price) {
            if ($price->getAmount() > 0 && $quantity >= $price->getAmount()) {
                if (is_object($quantityDiscountPrice)) {
                    if ($quantityDiscountPrice->getAmount() <= $price->getAmount()) {
                        $quantityDiscountPrice = $price;
                    }
                } else {
                    $quantityDiscountPrice = $price;
                }
            }
        }

        if (is_object($quantityDiscountPrice)) {
            if ($this->takeEuroPrice($currency->getShort(), $quantityDiscountPrice->getPriceEuro())) {
                return $quantityDiscountPrice->getPriceEuro();
            }

            return $quantityDiscountPrice->getPrice() * $currency->getFaktor();
        }
    }

    /**
     * Gets all ProductPrices, filtered by member Groups, and returns them as array
     * @param Currency $currency
     * @param array $memberGroups
     * @return array
     */
    private function getPossibleOptionalPrices($currency, $memberGroups)
    {
        $return = [];
        if (count($memberGroups) > 0 && $memberGroups[0] != null) {
            foreach ($this->prices as $price) {
                $priceGroups = $price->getUserGroups()
->toArray();
                if (empty($priceGroups)) {
                    $return[] = $price;
                } else {
                    foreach ($priceGroups as $group) {
                        if (in_array($group -> getUid(), $memberGroups)) {
                            $return[] = $price;
                        }
                    }
                }
            }
        } else {
            // Wenn Benutzer nicht eingeloggt
            foreach ($this->prices as $price) {
                $priceGroups = $price->getUserGroups()
->toArray();
                if (count($priceGroups) == 0) {
                    $return[] = $price;
                }
            }
        }

        return $return;
    }

    /**
     * Check if the EuroPrice Should be taken or the Original Price with Currency calculation
     * @param string $currencyShort
     * @return boolean
     */
    private function takeEuroPrice($currencyShort, mixed $price)
    {
        return $currencyShort == 'EUR' && $price !== null;
    }


    /**
     * Returns the correct default Price - one of these HAS TO be set
     * @param array $memberGroups
     * @param Currency $currency
     */
    private function getDefaultPrices($memberGroups, $currency, $isMember = false)
    {
        $hasMemberGroups = false;
        if (!empty($memberGroups)) {
            foreach ($memberGroups as $memberGroup) {
                if ($memberGroup > 0) {
                    $hasMemberGroups = true;
                    break;
                }
            }
        }

        if (($hasMemberGroups || $isMember) && $this->priceMember !== null) {
            if ($this->takeEuroPrice($currency->getShort(), $this-> priceMemberEuro)) {
                return $this -> priceMemberEuro;
            }

            return $this -> priceMember * $currency->getFaktor();
        }

        if ($this->takeEuroPrice($currency->getShort(), $this-> priceEuro)) {
            return $this -> priceEuro;
        }

        return $this -> price * $currency->getFaktor();
    }
}
