<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUserGroup;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
/**
 * Productprice
 */
class Productprice extends AbstractEntity
{
    /**
     * price
     *
     * @var float
     */
    protected $price;

    /**
     * isSpecialPrice
     *
     * @var boolean
     */
    protected $isSpecialPrice = false;

    /**
     * amount
     *
     * @var integer
     */
    protected $amount = 0;

    /**
     * priceEuro
     *
     * @var float
     */
    protected $priceEuro;

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;

    /**
     * currency
     *
     * @var Currency
     * @Lazy
     */
    protected $currency = null;

    /**
     * userGroups
     *
     * @var ObjectStorage<FrontendUserGroup>
     * @Lazy
     */
    protected $userGroups = null;

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     * @Cascade
     */
    protected $image = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    /**
     * Returns the isSpecialPrice
     *
     * @return boolean
     */
    public function getIsSpecialPrice()
    {
        return $this->isSpecialPrice;
    }

    /**
     * Sets the isSpecialPrice
     *
     * @param boolean $isSpecialPrice
     */
    public function setIsSpecialPrice($isSpecialPrice): void
    {
        $this->isSpecialPrice = $isSpecialPrice;
    }

    /**
     * Returns the boolean state of isSpecialPrice
     *
     * @return boolean
     */
    public function isIsSpecialPrice()
    {
        return $this->isSpecialPrice;
    }

    /**
     * Returns the amount
     *
     * @return integer
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Sets the amount
     *
     * @param integer $amount
     */
    public function setAmount($amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns the priceEuro
     *
     * @return float
     */
    public function getPriceEuro()
    {
        return $this->priceEuro;
    }

    /**
     * Sets the priceEuro
     *
     * @param float $priceEuro
     */
    public function setPriceEuro($priceEuro): void
    {
        $this->priceEuro = $priceEuro;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Returns the currency
     *
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * Sets the currency
     */
    public function setCurrency(Currency $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * Adds a FrontendUserGroup
     */
    public function addUserGroup(FrontendUserGroup $userGroup): void
    {
        $this->userGroups->attach($userGroup);
    }

    /**
     * Removes a FrontendUserGroup
     *
     * @param FrontendUserGroup $userGroupToRemove The FrontendUserGroup to be removed
     */
    public function removeUserGroup(FrontendUserGroup $userGroupToRemove): void
    {
        $this->userGroups->detach($userGroupToRemove);
    }

    /**
     * Returns the userGroups
     *
     * @return ObjectStorage<FrontendUserGroup> $userGroups
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }

    /**
     * Sets the userGroups
     *
     * @param ObjectStorage<FrontendUserGroup> $userGroups
     */
    public function setUserGroups(ObjectStorage $userGroups): void
    {
        $this->userGroups = $userGroups;
    }

    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Returns the imageLocalized
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImageLocalized()
    {
        //return $this->getImage();
        return $this->getLocalized('image');
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        $imgs = $this->getImageLocalized();
        return count($imgs) > 0 ? $imgs[0] : null;
    }


    /**
     * Sets the image
     *
     * @param ObjectStorage<FileReference> $image
     */
    public function setImage(ObjectStorage $image): void
    {
        $this->image = $image;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->userGroups = new ObjectStorage();
        $this->image = new ObjectStorage();
    }
}
