<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * Productvariant
 */
class Productvariant extends AbstractEntity
{
    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     * @Cascade("remove")
     */
    protected $image = null;

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Returns the imageLocalized
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImageLocalized()
    {
        //return $this->getImage();
        return $this->getLocalized('image');
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        $imgs = $this->getImageLocalized();
        return count($imgs) > 0 ? $imgs[0] : null;
    }


    /**
     * Sets the image
     *
     * @param ObjectStorage<FileReference> $image
     */
    public function setImage(ObjectStorage $image): void
    {
        $this->image = $image;
    }
}
