<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * Propertyvalue
 */
class Propertyvalue extends AbstractEntity
{
    protected ?string $propertyValue = null;

    protected ?string $propertyValueTextarea = null;

    protected ?float $propertyValueNumber = null;

    protected ?Property $property = null;

    public function getPropertyValue(): ?string
    {
        return $this->propertyValue;
    }

    public function setPropertyValue(?string $propertyValue): void
    {
        $this->propertyValue = $propertyValue;
    }


    public function setValue(?string $propertyValue): void
    {
        $this->setPropertyValue($propertyValue);
    }

    public function getProperty(): ?Property
    {
        return $this->property;
    }

    public function setProperty(Property $property): void
    {
        $this->property = $property;
    }

    public function getPropertyValueTextarea(): ?string
    {
        return $this->propertyValueTextarea;
    }

    public function setPropertyValueTextarea(?string $propertyValueTextarea): void
    {
        $this->propertyValueTextarea = $propertyValueTextarea;
    }

    public function getPropertyValueNumber(): ?float
    {
        return $this->propertyValueNumber;
    }

    public function setPropertyValueNumber(?float $propertyValueNumber): void
    {
        $this->propertyValueNumber = $propertyValueNumber;
    }

    public function getValue(): mixed
    {
        if ($this->property === null) {
            return '';
        }

        $valueFieldName = $this->property->getValueFieldName();

        $valueFieldNameTypeCamelCase = GeneralUtility::underscoredToUpperCamelCase($valueFieldName);

        $methodname = 'get' . $valueFieldNameTypeCamelCase;

        if (method_exists($this, $methodname)) {
            return $this->{$methodname}();
        }

        return $this->getPropertyValue();
    }
}
