<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * ReminderList
 */
class ReminderList extends AbstractEntity
{
    protected ?FeUser $user = null;

    /**
     * products
     *
     * @var ObjectStorage<Product>
     * @Cascade
     * @Lazy
     */
    protected ObjectStorage $products;
    

    public function __construct()
    {
        $this->initStorageObjects();
    }

    public function getUser(): ?FeUser
    {
        return $this->user;
    }

    public function setUser(?FeUser $user): void
    {
        $this->user = $user;
    }

    public function getProducts(): ObjectStorage
    {
        return $this->products;
    }

    public function setProducts(ObjectStorage $products): void
    {
        $this->products = $products;
    }

    public function addProduct(Product $product): void
    {
        $this->products->attach($product);
    }

    public function removeProduct(Product $product): void
    {
        $this->products->detach($product);
    }

    public function hasProduct(Product $product): bool
    {
        return $this->products->contains($product);
    }

    protected function initStorageObjects(): void
    {
        $this->products = new ObjectStorage();
    }
}
