<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
/**
 * Shop
 */
class Shop extends AbstractEntity
{
    protected string $name = '';
    protected string $companyName = '';
    protected string $companyUrl = '';
    protected string $companyDescription = '';
    protected float $vat = 0.0;

    /**
     * countries
     *
     * @var ObjectStorage<Country>
     * @Lazy
     */
    protected $countries = null;

    /**
     * currencies
     *
     * @var ObjectStorage<Currency>
     * @Lazy
     */
    protected $currencies = null;

    /**
     * defaultCountry
     *
     * @var Country
     */
    protected $defaultCountry = null;

    /**
     * paymentmethods
     *
     * @var ObjectStorage<PaymentMethod>
     * @Lazy
     */
    protected $paymentmethods = null;

    /**
     * portos
     *
     * @var ObjectStorage<Porto>
     * @Lazy
     */
    protected $portos = null;

    /**
     * shippingServices
     *
     * @var ObjectStorage<ShippingService>
     * @Lazy
     */
    protected $shippingServices = null;

    /**
     * defaultPorto
     *
     * @var Porto
     */
    protected $defaultPorto = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getCompanyName(): string
    {
        return $this->companyName;
    }

    public function setCompanyName(string $companyName): void
    {
        $this->companyName = $companyName;
    }

    public function getCompanyUrl(): string
    {
        return $this->companyUrl;
    }

    public function setCompanyUrl(string $companyUrl): void
    {
        $this->companyUrl = $companyUrl;
    }

    public function getCompanyDescription(): string
    {
        return $this->companyDescription;
    }

    public function setCompanyDescription(string $companyDescription): void
    {
        $this->companyDescription = $companyDescription;
    }

    public function getVat(): float
    {
        return $this->vat;
    }

    public function setVat(float $vat): void
    {
        $this->vat = $vat;
    }

    /**
     * Adds a Country
     */
    public function addCountry(Country $country): void
    {
        $this->countries->attach($country);
    }

    /**
     * Removes a Country
     *
     * @param Country $countryToRemove The Country to be removed
     */
    public function removeCountry(Country $countryToRemove): void
    {
        $this->countries->detach($countryToRemove);
    }

    /**
     * Returns the countries
     *
     * @return ObjectStorage<Country> $countries
     */
    public function getCountries()
    {
        if ($this->countries instanceof LazyLoadingProxy) {
            $this->countries->_loadRealInstance();
        }
        return $this->countries;
    }

    /**
     * Sets the countries
     *
     * @param ObjectStorage<Country> $countries
     */
    public function setCountries(ObjectStorage $countries): void
    {
        $this->countries = $countries;
    }

    /**
     * Adds a Currency
     */
    public function addCurrency(Currency $currency): void
    {
        $this->currencies->attach($currency);
    }

    /**
     * Removes a Currency
     *
     * @param Currency $currencyToRemove The Currency to be removed
     */
    public function removeCurrency(Currency $currencyToRemove): void
    {
        $this->currencies->detach($currencyToRemove);
    }

    /**
     * Returns the currencies
     *
     * @return ObjectStorage<Currency> $currencies
     */
    public function getCurrencies()
    {
        if ($this->currencies instanceof LazyLoadingProxy) {
            $this->currencies->_loadRealInstance();
        }
        return $this->currencies;
    }

    /**
     * Sets the currencies
     *
     * @param ObjectStorage<Currency> $currencies
     */
    public function setCurrencies(ObjectStorage $currencies): void
    {
        $this->currencies = $currencies;
    }

    public function getCurrenciesAssociative()
    {
        $currenciesAssociative = [];
        foreach ($this->currencies as $currency) {
            $currenciesAssociative[$currency->getShort()] = $currency;
        }

        return $currenciesAssociative;
    }

    /**
     * Returns the defaultCountry
     *
     * @return Country
     */
    public function getDefaultCountry()
    {
        return $this->defaultCountry;
    }

    /**
     * Sets the defaultCountry
     */
    public function setDefaultCountry(Country $defaultCountry): void
    {
        $this->defaultCountry = $defaultCountry;
    }

    /**
     * Adds a PaymentMethod
     */
    public function addPaymentMethod(PaymentMethod $paymentmethod): void
    {
        $this->paymentmethods->attach($paymentmethod);
    }

    /**
     * Removes a PaymentMethod
     *
     * @param PaymentMethod $paymentmethodToRemove The PaymentMethod to be removed
     */
    public function removePaymentMethod(PaymentMethod $paymentmethodToRemove): void
    {
        $this->paymentmethods->detach($paymentmethodToRemove);
    }

    /**
     * Returns the paymentmethods
     *
     * @return ObjectStorage<PaymentMethod> $paymentmethods
     */
    public function getPaymentMethods()
    {
        if ($this->paymentmethods instanceof LazyLoadingProxy) {
            $this->paymentmethods->_loadRealInstance();
        }
        return $this->paymentmethods;
    }

    /**
     * Sets the paymentmethods
     *
     * @param ObjectStorage<PaymentMethod> $paymentmethods
     */
    public function setPaymentMethods(ObjectStorage $paymentmethods): void
    {
        $this->paymentmethods = $paymentmethods;
    }

    /**
     * Adds a Porto
     */
    public function addPorto(Porto $porto): void
    {
        $this->portos->attach($porto);
    }

    /**
     * Removes a Porto
     *
     * @param Porto $portoToRemove The Porto to be removed
     */
    public function removePorto(Porto $portoToRemove): void
    {
        $this->portos->detach($portoToRemove);
    }

    /**
     * Returns the portos
     *
     * @return ObjectStorage<Porto> $portos
     */
    public function getPortos()
    {
        if ($this->portos instanceof LazyLoadingProxy) {
            $this->portos->_loadRealInstance();
        }
        return $this->portos;
    }

    /**
     * Returns the portos
     *
     * @return array
     */
    public function getPortosForCountry($country)
    {
        if (!is_object($country)) {
            return null;
        }

        /*
        $query = $this->createQuery();
        // @TODO something is completely broken DA [multilanguage sites]
        $query->getQuerySettings()->setRespectSysLanguage(false);
        $query->matching(
            $query->logicalOr(
                $query->contains('country',$country),
                $query->equals('countryAll', true)
            )
        );
        return $query->executeQuery();
        */

        $portos = [];
        foreach ($this->portos as $porto) {
            if ($porto->getCountryAll() || $porto->getCountry() == $country) {
                $portos[] = $porto;
            }
        }

        return $portos;
    }

    /**
     * Sets the portos
     *
     * @param ObjectStorage<Porto> $portos
     */
    public function setPortos(ObjectStorage $portos): void
    {
        $this->portos = $portos;
    }

    /**
     * Adds a ShippingService
     */
    public function addShippingService(ShippingService $shippingService): void
    {
        $this->shippingServices->attach($shippingService);
    }

    /**
     * Removes a ShippingService
     *
     * @param ShippingService $shippingServicetoRemove The ShippingService to be removed
     */
    public function removeShippingService(ShippingService $shippingServicetoRemove): void
    {
        $this->shippingServices->detach($shippingServicetoRemove);
    }

    /**
     * Returns the shippingServices
     *
     * @return ObjectStorage<ShippingService> $shippingServices
     */
    public function getShippingServices()
    {
        if ($this->shippingServices instanceof LazyLoadingProxy) {
            $this->shippingServices->_loadRealInstance();
        }
        return $this->shippingServices;
    }

    /**
     * Sets the shippingServices
     *
     * @param ObjectStorage<ShippingService> $shippingServices
     */
    public function setShippingServices(ObjectStorage $shippingServices): void
    {
        $this->shippingServices = $shippingServices;
    }


    /**
     * Returns the defaultPorto
     *
     * @return Porto
     */
    public function getDefaultPorto()
    {
        return $this->defaultPorto;
    }

    /**
     * Returns the defaultPorto
     *
     * @return Porto
     */
    public function getDefaultPortoForCountry($country)
    {
        if ($this->defaultPorto->hasCountry($country)) {
            return $this->defaultPorto;
        }

        // @todo analog altem Code
        //$countryPortos = $this->getPortosForCountry($country);
        //return $countryPortos->getFirst();
        return null;
    }

    /**
     * Sets the defaultPorto
     */
    public function setDefaultPorto(Porto $defaultPorto): void
    {
        $this->defaultPorto = $defaultPorto;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->countries = new ObjectStorage();
        $this->currencies = new ObjectStorage();
        $this->paymentmethods = new ObjectStorage();
        $this->portos = new ObjectStorage();
        $this->shippingServices = new ObjectStorage();
    }
}
