<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use InternetGalerie\Igshop2\Domain\Model\Order;
use InternetGalerie\Igshop2\Domain\Model\Currency;
use DateTime;
use InternetGalerie\Igshop2\Domain\Model\FeUser;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for Orders
 */
class AbstractOrderRepository extends Repository
{
    protected string $sessionName = '';
    protected $defaultOrderings = [
        'uid' => QueryInterface::ORDER_DESCENDING,
    ];

    /*
     * public function saveToSession(\InternetGalerie\Igshop2\Domain\Model\Order $order = null) { $this->session->registerObject($order, "order"); } public function getFromSession() { $result = $this->session->getObjectByIdentifier("order"); if (!$result) { $result = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance("\\InternetGalerie\\Igshop2\\Domain\\Model\\Order"); } return $result; }
     */
    /**
     * gibt den aktuellen benutzerwarenkorb zurück.
     * existiert keins, dann wird ein neuer wk angelegt.
     * wurde ein wk abgeschickt, so wird ebenfalls ein neuer wk angelegt
     * @return mixed
     */
    public function getCurrent(Currency $currency = null, ?FeUser $feUser)
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        //expects: if there is an active order then session "shopCart" must have valid order-uid
        //enshures: returns active order, if there is no active order, then one is created, order-uid is stored to session "shopCart"

        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $sessionCartId = $frontendUser ? intval($frontendUser->getKey('ses', $this->sessionName)) : 0;
        $order = null;
        if($feUser && $feUser->getCurrentOrder() && $feUser->getCurrentOrder()->getTotalProductsCount() > 0) {
            $order = $feUser->getCurrentOrder();
            if($order && $order->getSubmitted()) {
                $order = null;
            }
        }
        if (!$order && $sessionCartId > 0) {//if order is in session
            $query = $this->createQuery();
            $query->getQuerySettings()->setRespectSysLanguage(false);
            //$query->getQuerySettings()->setLanguageOverlayMode(false);
            $query->matching($query->logicalAnd(
                $query->equals('submitted', 0),
                $query->equals('uid', $sessionCartId)
                //,                $query->equals('userid', 0)
            ));

            $queryResult = $query->execute();

            if ($queryResult->count() > 0) {//if order valid, eg after submit is sassion!=0 but active order not present.
                $order = $queryResult->getFirst();
            }
        }

        if($order && $order->getUserid() && $order->getUserid() != $userId) {
            $order = null;
        }

        if ($order === null) {
            $order = GeneralUtility::makeInstance($this->objectType);
            //$order = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance("InternetGalerie\\Igshop2\\Domain\\Model\\Order");
            if (is_object($currency)) {
                $order->setCurrency($currency);
            }

            $order->setOrderdate(new DateTime());
        }

        if ($isLoggedIn) {
            $order->setUserId($userId);
        }

        $this->persist($order);

        /*
        // gute Idee -> aber dann crdate oben anpassen
        $deleteQuery = $this->createQuery();
        //$date = new \DateTime('midnight');
        $deleteQuery->matching(
        $deleteQuery->logicalAnd(
        $deleteQuery->lessThanOrEqual('crdate', time()-84600),
        $deleteQuery->equals("submitted", 0),
        $deleteQuery->equals("products", 0)
        )
        );
        $ordersToDelete = $deleteQuery->execute()->toArray();
        foreach($ordersToDelete AS $delete){
        $this->remove($delete);
        }*/

        return $order;
    }

    /**
     * @return Order
     */
    public function getCurrentForUser($feUser, $currency)
    {
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $sessionCartId = $frontendUser ? intval($frontendUser->getKey('ses', $this->sessionName)) : 0;
        if ($sessionCartId > 0) {//if order is in session and we have no current order on the user
            $query = $this->createQuery();
            $query->getQuerySettings()->setRespectSysLanguage(false);
            //$query->getQuerySettings()->setLanguageOverlayMode(false);
            $query->matching($query->logicalAnd($query->equals('submitted', 0), $query->equals('uid', $sessionCartId)));
            $queryResult = $query->execute();
            if ($queryResult->count() > 0) {//if order valid, eg after submit is sassion!=0 but active order not present.
                $order = $queryResult->getFirst();
            }
        }

        if ($order == null) {
            $order = $feUser->getCurrentOrder();
        }

        // Create new order if there is none or if the current order already got submitted
        if ($order == null || (is_object($order) && $order->getSubmitted())) {
            $order = GeneralUtility::makeInstance(Order::class);
            if (is_object($currency)) {
                $order->setCurrency($currency);
            }

            $order->setOrderdate(new DateTime());
            $order->setUserId($feUser->getUid());
        }

        $this->persist($order);
        //$GLOBALS['TSFE']->fe_user->setKey('ses', $this->sessionName, ''); // We don't need the order in the session if we have a user

        return $order;
    }

    public function findBySubmittedLimited($submitted, int $pid, $limited = null)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(false);
        //$query->getQuerySettings()->setLanguageOverlayMode(false);
        if ($limited != null && $limited > 0) {
            $query->setLimit($limited);
        }

        $query->getQuerySettings()->setRespectStoragePage(false);
        $query->matching(
            $query->logicalAnd(
                $query->equals('submitted', $submitted),
                $query->equals('pid', $pid),
                $query->greaterThan('products', 0),
                $query->logicalNot($query->equals('paymentMethod', 0)),
                $query->logicalNot($query->equals('orderinfo', ''))
            )
        );

        return $query->execute();
    }

    public function getFromUser($userId, $sorting = 'orderdate')
    {
        if ($userId > 0) {
            $query = $this->createQuery();
            $query->getQuerySettings()->setRespectSysLanguage(false);
            //$query->getQuerySettings()->setLanguageOverlayMode(false);
            $query->matching($query->logicalAnd($query->equals('submitted', 1), $query->equals('userid', $userId)));
            $query->setOrderings(
                [
                    'orderdate' => QueryInterface::ORDER_DESCENDING,
                ]
            );
            return $queryResult = $query->execute();
        }

        return 0;
    }

    /**
     * @param mixed $order
     */
    public function persist($order): void
    {
        $context = GeneralUtility::makeInstance(Context::class);
        //enshures: order is saved to db and session.shopCart=order.uid
        $GLOBALS['TYPO3_CONF_VARS']['SYS']['cookieDomain'] = $_SERVER['HTTP_HOST'];

        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $order->setUserId($context->getPropertyFromAspect('frontend.user', 'id'));
        } else {
            $order->setUserId(0);
        }

        if ($order->_isNew()) {
            $this->add($order);
        } else {
            $this->update($order);
        }

        $this->persistenceManager->persistAll();
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        if ($frontendUser) {
            $frontendUser->setKey('ses', $this->sessionName, $order->getUid());
            $frontendUser->storeSessionData();
        }

        //echo('session  order is saved('.$order->getUid().')<br />');
        $this->persistenceManager->persistAll();
    }

    /**
     * Suchfunktion für die Backend Bestelliste
     *
     * @param int $limited
     * @param int $pid
     * @param string $searchKeys Suchwort der Eingabemaske
     * @param array $uids
     * @param DateTime $vonDate
     * @param DateTime $bisDate
     * @param boolean $carts
     * @return ObjectStorage<Order>
     */
    public function findByOrderInfoLimited(
        $limited,
        int $pid,
        $searchKeys = null,
        $uids = null,
        $vonDate = null,
        $bisDate = null,
        $carts = false
    ) {
        $query = $this->createQuery();

        $query->getQuerySettings()->setRespectSysLanguage(false);
        //$query->getQuerySettings()->setLanguageOverlayMode(false);
        $query->getQuerySettings()->setRespectStoragePage(false);

        if ($limited != null && $limited > 0) {
            $query->setLimit($limited);
        }

        $constraints = [];

        $constraints[] = $query->equals('submitted', !$carts);

        if ($searchKeys != null) {
            $constraints[] = $query->like('orderinfo', '%' . $searchKeys . '%');
        }

        if (count($uids) > 0) {
            $constraints[] = $query->in('uid', $uids);
        }

        if ($vonDate) {
            $constraints[] = $query->greaterThanOrEqual('tstamp', $vonDate->getTimestamp());
        }

        if ($bisDate) {
            $constraints[] = $query->lessThanOrEqual('tstamp', $bisDate->getTimestamp());
        }

        if ($pid > 0) {
            $constraints[] = $query->equals('pid', $pid);
        }

        $constraints[] = $query->greaterThan('products', 0);

        $constraints[] = $query->logicalNot($query->equals('paymentMethod', 0));

        $constraints[] = $query->logicalNot($query->equals('orderinfo', ''));

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }
}
