<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use InternetGalerie\Igshop2\Domain\Model\FeUser;
use InternetGalerie\Igshop2\Domain\Model\ProductComparison;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for ProductComparisons
 */
class ProductComparisonRepository extends Repository
{
    public function getCurrentProductComparison($productComparisonUid = null, ?FeUser $feUser = null): ProductComparison
    {
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $productComparison = null;

        if ($feUser) {
            $productComparison = $this->findOneByUser($feUser->getUid());
        } 
        if (!$productComparison && !is_null($productComparisonUid)) {
            $productComparison = $this->findByUid($productComparisonUid);
            if(($productComparison->getUser() && !$feUser) || ($productComparison->getUser() && $feUser && $productComparison->getUser()->getUid() != $feUser->getUid())) {
                $productComparison = null;
            }
        }
        if(!$productComparison) {
            $sessionProductComparisonUid = $frontendUser ? intval(
                $frontendUser->getKey('ses', 'shopProductComparison')
            ) : 0;
            if ($sessionProductComparisonUid) {
                $productComparison = $this->findByUid($sessionProductComparisonUid);
            }
            if (!$productComparison) {
                $productComparison = GeneralUtility::makeInstance(ProductComparison::class);
            }
        }

        $context = GeneralUtility::makeInstance(Context::class);
        //enshures: order is saved to db and session.shopCart=order.uid

        // TODO: int brauchen für User?
        if ($feUser !== null) {
            $productComparison->setUser($feUser);
        } else {
            $productComparison->setUser(null);
        }

        if ($productComparison->_isNew()) {
            $this->add($productComparison);
        } else {
            $this->update($productComparison);
        }
        
        $this->persistenceManager->persistAll();

        if ($frontendUser) {
            $frontendUser->setKey('ses', 'shopProductComparison', $productComparison->getUid());
            $frontendUser->storeSessionData();
        }

        return $productComparison;
    }
}
