<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use InternetGalerie\Igshop2\Domain\Model\Survey;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2017
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * The repository for Surveys
 */
class SurveyRepository extends Repository
{
    /**
     * Find by multiple uids
     *
     * @param array $uids Uids
     * @return ObjectStorage<Survey> $survey
     */
    public function findWithUidsArray($uids)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectSysLanguage(false);

        $uidsConstraint = [];
        foreach ($uids as $nr => $uid) {
            $uidsConstraint[] = $query->equals('uid', $uid);
        }

        if (count($uidsConstraint) == 0) {
            $uidsConstraint[] = $query->equals('uid', -1);
        }

        $query->matching(
            //		     $query->in( 'uid', [0=>2,1=>3])
            $query->logicalOr($uidsConstraint)
        );
        $objectStorage = GeneralUtility::makeInstance(ObjectStorage::class);
        foreach ($query->execute() as $object) {
            $objectStorage->attach($object);
        }

        return $objectStorage;
    }
}
