<?php

declare(strict_types=1);

namespace InternetGalerie\Igshop2\Form\Element;

use TYPO3\CMS\Backend\Form\Element\AbstractFormElement;
use TYPO3\CMS\Backend\Form\Element\CheckboxToggleElement;
use TYPO3\CMS\Backend\Form\Element\InputTextElement;
use TYPO3\CMS\Backend\Form\Element\NumberElement;
use TYPO3\CMS\Backend\Form\Element\TextElement;
use TYPO3\CMS\Core\Configuration\Richtext;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Html\RteHtmlParser;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\StringUtility;
use TYPO3\CMS\RteCKEditor\Form\Element\RichTextElement;

class PropertyFieldsElement extends AbstractFormElement
{
    protected const TABLE_NAME_PROPERTY = 'tx_igshop2_domain_model_property';

    protected const TABLE_NAME_CATEGORY_PROPERTY_MM = 'tx_igshop2_category_property_mm';

    public function render(): array
    {
        $data = $this->data;
        $categories = $data['databaseRow']['category'] ?? [];
        $properties = [];
        $fieldName = $data['fieldName'];
        $connectionPool = GeneralUtility::makeInstance(ConnectionPool::class);
        $record = $data['databaseRow'];
        $config = $data['processedTca']['columns'][$fieldName]['config'];
        $foreignTable = $config['foreign_table'];
        $parentField = $config['foreign_field'];
        $this->foreignTable = $foreignTable;
        $tableName = $data['tableName'];
        $appendFParentFieldNames = '[' . $tableName . '][' . ($record['uid'] ?? 0) . ']';

        $resultArray = $this->initializeResultArray();

        $fieldInformationResult = $this->renderFieldInformation();
        $resultArray = $this->mergeChildReturnIntoExistingResult($resultArray, $fieldInformationResult, false);

        if (!empty($categories)) {
            // Get all properties for the product categories

            $categoryUids = array_map('intval', $categories);
            $queryBuilder = $connectionPool->getQueryBuilderForTable(self::TABLE_NAME_PROPERTY);
            $properties = $queryBuilder->select(self::TABLE_NAME_PROPERTY . '.*')
                                       ->distinct()
                                       ->from(self::TABLE_NAME_PROPERTY)
                                       ->join(
                                           self::TABLE_NAME_PROPERTY,
                                           self::TABLE_NAME_CATEGORY_PROPERTY_MM,
                                           self::TABLE_NAME_CATEGORY_PROPERTY_MM,
                                           'uid = uid_foreign'
                                       )
                                       ->where(
                                           $queryBuilder->expr()
->in('uid_local', $queryBuilder->createNamedParameter($categoryUids, Connection::PARAM_INT_ARRAY))
                                       )
                                       ->andWhere('deleted = 0 AND hidden = 0')
                                       ->orderBy(self::TABLE_NAME_PROPERTY . '.sorting')
                                       ->executeQuery()
                                       ->fetchAllAssociative();
        }

        if (!empty($properties)) {
            // Only do something if there are properties
            if ((is_numeric($record['uid']) && $record['uid'] > 0 && !empty($properties)) || 1) {
                $html = [];
                $i = 0;
                $sorting = 1;


                $propertyValueUids = [];
                // Loop through properties and generate field html
                foreach ($properties as $property) {
                    $qb = $connectionPool->getQueryBuilderForTable('tx_igshop2_domain_model_propertyvalue');

                    $existingPropertyvalue = '';
                    if (is_numeric($record['uid']) && $record['uid'] > 0) {
                        $existingPropertyvalue = $qb->select('*')
                                            ->from('tx_igshop2_domain_model_propertyvalue')
                                            ->where('product = ' . $record['uid'])
                                            ->andWhere('property = ' . $property['uid'])
                                            ->andWhere('deleted = 0 AND hidden = 0')
                                            ->executeQuery()
                                            ->fetchAssociative();
                    }

                    $propertyValueUid = $existingPropertyvalue ? $existingPropertyvalue['uid'] : StringUtility::getUniqueId(
                        'NEW'
                    );
                    $propertyValueUids[] = $propertyValueUid;

                    $prefix = htmlspecialchars('data[' . $foreignTable . '][' . $propertyValueUid . ']');


                    $valueFieldName = $this->getValueFieldName($property);
                    $propertyPartial = $property['field_type'];

                    $itemValue = null;
                    if ($existingPropertyvalue && $valueFieldName) {
                        $itemValue = isset($existingPropertyvalue[$valueFieldName]) ? (string)$existingPropertyvalue[$valueFieldName] : null;
                    }

                    $label = $property['name'];

                    if ($propertyPartial == 'List') {
                        $label .= ' (Liste: Jede Zeile ist ein Listenpunkt)';
                    }

                    if ($property['unit']) {
                        $label .= ' (' . $property['unit'] . ')';
                    }

                    $html[] = '<fieldset class="form-section">';
                    $html[] = '<div class="form-group t3js-formengine-validation-marker t3js-formengine-palette-field">';
                    $html[] = '<fieldset>';
                    $html[] = '<input type="hidden" value="' . $sorting++ . '" ';
                    $html[] = 'name="' . $prefix . '[sorting]" class="form-control"';
                    $html[] = ' />';
                    $html[] = '<input type="hidden" value="' . $record['sys_language_uid'] . '" ';
                    $html[] = 'name="' . $prefix . '[sys_language_uid]" class="form-control"';
                    $html[] = ' />';
                    $html[] = '<input type="hidden" value="' . $record['pid'] . '" ';
                    $html[] = 'name="' . $prefix . '[pid]" class="form-control"';
                    $html[] = ' />';
                    $html[] = '<input type="hidden" value="' . $property['uid'] . '" ';
                    $html[] = 'name="' . $prefix . '[property]" class="form-control"';
                    $html[] = ' />';

                    switch ($propertyPartial) {
                        case 'Checkbox':
                            $checkboxToggleResultArray = $this->getCheckbox(
                                $label,
                                $prefix,
                                $valueFieldName,
                                $itemValue
                            );
                            $resultArray = $this->mergeChildReturnIntoExistingResult(
                                $resultArray,
                                $checkboxToggleResultArray,
                                false
                            );
                            $html[] = $checkboxToggleResultArray['html'];
                            break;
                        case 'Rte':
                            $rteResultArray = $this->getRte($record, $label, $prefix, $valueFieldName, $itemValue);
                            $resultArray = $this->mergeChildReturnIntoExistingResult(
                                $resultArray,
                                $rteResultArray,
                                false
                            );
                            $html[] = $rteResultArray['html'];
                            break;
                        default:
                            $textResultArray = $this->getText(
                                $record,
                                $label,
                                $prefix,
                                $valueFieldName,
                                $itemValue,
                                $propertyValueUid
                            );
                            $resultArray = $this->mergeChildReturnIntoExistingResult(
                                $resultArray,
                                $textResultArray,
                                false
                            );
                            $html[] = $textResultArray['html'];
                            break;
                    }

                    //$appendFormFieldNames = '[' . $foreignTable . '][' . $propertyValueUid . ']';
                    //$html[] = '<input type="hidden" name="uc[inlineView]' . $appendFParentFieldNames . $appendFormFieldNames . '" value="' . $i .'" />';


                    $html[] = '</fieldset>';
                    $html[] = '</div>';
                    $html[] = '</fieldset>';

                    ++$i;
                }

                //var_Dump($data);exit();
                $parameterArray = $data['parameterArray'];
                $itemFormElName = htmlspecialchars((string) $parameterArray['itemFormElName']);
                $fieldValue = implode(',', $propertyValueUids);
                $html[] = '<input type="hidden" value="' . $fieldValue . '" ';
                $html[] = 'name="' . $itemFormElName . '" class="form-control"';
                $html[] = ' />';
                $resultArray['html'] = implode(LF, $html);
            }
        }

        return $resultArray;
    }

    protected function getText($record, $label, $prefix, $valueFieldName, ?string $itemValue, $propertyValueUid): array
    {
        $textData = $this->data;

        $textData['parameterArray']['itemFormElName'] = $prefix . '[' . $valueFieldName . ']';
        $textData['parameterArray']['itemFormElID'] = rtrim(
            str_replace(['][', '[', ']'], '_', $textData['parameterArray']['itemFormElName']),
            '_'
        );
        $textData['parameterArray']['itemFormElValue'] = $itemValue;
        $textData['parameterArray']['fieldConf']['label'] = $label;
        $textData['tableName'] = $this->foreignTable;
        $textData['fieldName'] = $valueFieldName;
        $textData['processedTca']['columns'][$valueFieldName] = $GLOBALS['TCA'][$this->foreignTable]['columns'][$valueFieldName];
        $textData['databaseRow']['uid'] = $propertyValueUid;
        unset($textData['parameterArray']['fieldChangeFunc']['TBE_EDITOR_fieldChanged']);
        if ($valueFieldName == 'property_value_number') {
            $textData['parameterArray']['fieldConf']['config']['format'] = 'decimal';
            $textData['parameterArray']['fieldConf']['config']['nullable'] = true;
            $textElement = GeneralUtility::makeInstance(NumberElement::class, $this->nodeFactory, $textData);
        }

        if ($valueFieldName == 'property_value_textarea') {
            $textElement = GeneralUtility::makeInstance(TextElement::class, $this->nodeFactory, $textData);
        } elseif ($valueFieldName == 'property_value') {
            $textElement = GeneralUtility::makeInstance(InputTextElement::class, $this->nodeFactory, $textData);
        }

        $textResultArray = $textElement->render();
        return $textResultArray;
    }

    protected function getCheckbox($label, $prefix, $valueFieldName, $itemValue): array
    {
        $checkboxToggleData = $this->data;
        $checkboxToggleData['parameterArray']['itemFormElName'] = $prefix . '[' . $valueFieldName . ']';
        $checkboxToggleData['parameterArray']['itemFormElID'] = rtrim(
            str_replace(['][', '[', ']'], '_', $checkboxToggleData['parameterArray']['itemFormElName']),
            '_'
        );
        $checkboxToggleData['parameterArray']['itemFormElValue'] = $itemValue;
        $checkboxToggleData['parameterArray']['fieldConf']['label'] = $label;
        //$checkboxToggleData['parameterArray']['fieldConf']['config']['nullable'] = true;
        $checkboxToggleData['parameterArray']['fieldConf']['config']['items'] = [
            [
                'label' => '',
                'invertStateDisplay' => false,
            ],
        ];
        unset($checkboxToggleData['parameterArray']['fieldChangeFunc']['TBE_EDITOR_fieldChanged']);
        $checkboxToggleElement = GeneralUtility::makeInstance(
            CheckboxToggleElement::class,
            $this->nodeFactory,
            $checkboxToggleData
        );
        $checkboxToggleResultArray = $checkboxToggleElement->render();
        return $checkboxToggleResultArray;
    }

    protected function getRte($record, $label, $prefix, $valueFieldName, $itemValue): array
    {
        $rteData = $this->data;
        $rteData['parameterArray']['itemFormElName'] = $prefix . '[' . $valueFieldName . ']';
        $rteData['parameterArray']['itemFormElID'] = rtrim(
            str_replace(['][', '[', ']'], '_', $rteData['parameterArray']['itemFormElName']),
            '_'
        );
        $rteData['parameterArray']['itemFormElValue'] = $itemValue;
        $rteData['parameterArray']['fieldConf']['label'] = $label;
        $rteData['parameterArray']['fieldConf']['config']['enableRichtext'] = true;
        $rteData['parameterArray']['fieldConf']['config']['richtextConfigurationName'] = '';
        unset($rteData['parameterArray']['fieldChangeFunc']['TBE_EDITOR_fieldChanged']);

        $richtextConfigurationProvider = GeneralUtility::makeInstance(Richtext::class);
        $richtextConfiguration = $richtextConfigurationProvider->getConfiguration(
            'tx_igshop2_domain_model_propertyvalue',
            $valueFieldName,
            $record['pid'],
            '',
            $rteData['parameterArray']['fieldConf']['config']
        );
        // Transform if richtext is not disabled in configuration
        if (!($richtextConfiguration['disabled'] ?? false)) {
            // remember RTE preset name
            $rteData['processedTca']['columns'][$valueFieldName]['config']['richtextConfigurationName'] = '';//$fieldConfig['config']['richtextConfiguration'] ?? '';
            // Add final resolved configuration to TCA array
            $rteData['processedTca']['columns'][$valueFieldName]['config']['richtextConfiguration'] = $richtextConfiguration;
            // If eval=null is set for field, value might be null ... don't transform anything in this case.
            $rteData['databaseRow'][$valueFieldName] = null;
            if ($rteData['databaseRow'][$valueFieldName] !== null) {
                // Process "from-db-to-rte" on current value
                $richTextParser = GeneralUtility::makeInstance(RteHtmlParser::class);
                $rteData['databaseRow'][$valueFieldName] = $richTextParser->transformTextForRichTextEditor(
                    $rteData['databaseRow'][$valueFieldName],
                    $richtextConfiguration['proc.'] ?? []
                );
            }
        }

        $rteData['parameterArray']['fieldConf']['config']['richtextConfiguration'] = $richtextConfiguration;
        $rteElement = GeneralUtility::makeInstance(RichTextElement::class, $this->nodeFactory, $rteData);
        $rteResultArray = $rteElement->render();
        return $rteResultArray;
    }

    protected function getValueFieldName($property)
    {
        return match ($property['field_type']) {
            'Checkbox', 'Float' => 'property_value_number',
            'Textarea', 'Rte' => 'property_value_textarea',
            default => 'property_value',
        };
    }
}
