<?php

declare(strict_types=1);

namespace InternetGalerie\Igshop2\Form\FormDataProvider;

use TYPO3\CMS\Backend\Form\FormDataProvider\TcaInline as CoreTcaInline;

/**
 * the tca child rendering takes a lot of time (up to 20s) and we do not need it
 * we will rendering the field in InternetGalerie\Igshop2\Form\Element\PropertyFieldsElement
 * we register our TcaInline in ext_localconf.php and we must remove the core one TYPO3\CMS\Backend\Form\FormDataProvider\TcaInline
 * this is done in $GLOBALS['TYPO3_CONF_VARS']['SYS']['formEngine']['formDataGroup']['tcaDatabaseRecord']
 * this is possible ugly because TcaInline core is used in depends of other (including ours)
 */


class TcaInline extends CoreTcaInline
{
    /**
     * Resolve inline fields
     *
     * @return array
     */
    public function addData(array $result)
    {
        $result = $this->addInlineFirstPid($result);

        foreach ($result['processedTca']['columns'] as $fieldName => $fieldConfig) {
            if (!$this->isInlineField($fieldConfig)) {
                continue;
            }

            $result['processedTca']['columns'][$fieldName]['children'] = [];
            if (!$this->isUserAllowedToModify($fieldConfig)) {
                continue;
            }

            // IG add && ($result['processedTca']['columns'][$fieldName]['config']['inlineCompileExistingChildren'] ?? true)
            if ($result['inlineResolveExistingChildren'] && ($result['processedTca']['columns'][$fieldName]['config']['inlineCompileExistingChildren'] ?? true)) {
                $result = $this->resolveRelatedRecords($result, $fieldName);
                $result = $this->addForeignSelectorAndUniquePossibleRecords($result, $fieldName);
            }
        }

        return $result;
    }
}
