<?php

namespace InternetGalerie\Igshop2\Hooks\Datahandler;

use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;

class CommandMapPostProcessingHook
{
    protected string $targetTable = 'tx_igshop2_domain_model_product';


    public function processCmdmap_postProcess(
        string $command,
        string $table,
        $id,
        $value,
        DataHandler $dataHandler,
        $pasteUpdate,
        $pasteDatamap
    ): void {
        $redirect = $_GET['redirect'] ?? $_POST['redirect'] ?? '';
        if ($command !== 'move' || $table !== $this->targetTable || $redirect === '') {
            return;
        }

        if (!MathUtility::canBeInterpretedAsInteger($id) || (int)$id === 0) {
            return;
        }

        if (!$GLOBALS['TCA'][$table]) {
            return;
        }

        $sortTable = 'tx_igshop2_product_category_mm';

        $uid = (int) $id;
        $destination = (int)$value;
        $destinationUid = abs($destination);
        $toTop = $destination > 0;


        $queryString = parse_url((string) $redirect, PHP_URL_QUERY);
        parse_str($queryString, $params);
        $uidForeign = (int)$params['entryId'];
        if ($uidForeign < 1) {
            return;
        }

        /*
        echo ('Entry to move: ' . $uid . '(' . $table . ')<br />');
        echo ('Foreign Uid=: ' . $uidForeign . '<br />');
        echo ('To Top=: ' . ($toTop ? 'Ja' : 'Nein') . '<br />');
        echo ('Target uid=' . $destinationUid . '(' . $sortTable . ')<br />');

        var_dump($command, $table, $uid, $value,$pasteUpdate, $uidForeign, $sortTable, $destinationUid);exit(0);
        */
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                      ->getQueryBuilderForTable($sortTable);
        //$queryBuilder->getRestrictions()->removeByType(HiddenRestriction::class);
        $entries = $queryBuilder
                 ->from($sortTable)
                 ->select('sorting_foreign', 'uid_local', 'uid_foreign')
                 ->where($queryBuilder->expr()->eq(
                     'uid_foreign',
                     $queryBuilder->createNamedParameter($uidForeign, PDO::PARAM_INT)
                 ))
                 ->orderBy('sorting_foreign', 'ASC')
                 ->executeQuery()
                 ->fetchAllAssociative();
        $newSorting = $toTop ? 2 : 0;
        $destinationFound = false;
        $source = null;
        $sourceSorting = 2;
        foreach ($entries as $entry) {
            if ($entry['uid_local'] == $uid) {
                $source = $entry;
            } else {
                $newSorting += 2;
                $this->updateEntry($sortTable, $entry['uid_local'], $uidForeign, [
                    'sorting_foreign' => $newSorting,
                ]);
            }

            if (!$toTop && $entry['uid_local'] == $destinationUid) {
                $newSorting += 2;
                $sourceSorting = $newSorting;
            }
        }

        if ($source !== null) {
            $this->updateEntry($sortTable, $source['uid_local'], $uidForeign, [
                'sorting_foreign' => $sourceSorting,
            ]);
        }
    }

    protected function updateEntry(string $sortTable, int $uidLocal, int $uidForeign, array $updateFields)
    {
        return GeneralUtility::makeInstance(ConnectionPool::class)
            ->getConnectionForTable($sortTable)
            ->update($sortTable, $updateFields, [
                'uid_local' => $uidLocal,
                'uid_foreign' => $uidForeign,
            ]);
    }
}
