<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class FgetContentViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('filePath', 'string', 'File path', true);
    }
    
    /**
     * Counts how often a Value is in a given Array
     *
     * @return int
     */
    public function render(): string
    {
        $filePath = $this->arguments['filePath'];

        if (file_exists($filePath)) {
            return file_get_contents($filePath);
        }

        return false;
    }
}
