<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;

/*
  <shop:ajax.div action="cart"><img src="/fileadmin/layout/images_layout/bag.svg" width="20" /> (<shop:ajax.field name="count">0</shop:ajax.field>)</shop:ajax.div>
*/

class CartViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }



    public function injectUriBuilder(UriBuilder $uriBuilder): void
    {
        $this->uriBuilder = $uriBuilder;
    }


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('class', 'string', 'Extra Klassen', false, '');
        //$this->registerArgument('cartPageUid' 'int', 'Page Uid of Cart', true); // muss dies in Settings
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'Igshop2',
            ''
        );

        $cartPid = intval($this->settings['cartPid']);

        /** @var RenderingContext **/
        $renderingContext = $this->renderingContext;
        $request = $renderingContext->getRequest();
        $extbaseRequest = new Request($request->withAttribute('extbase', new ExtbaseRequestParameters()));
        $cartUriBuilder = $this->uriBuilder->reset()
->setRequest($extbaseRequest)
->setTargetPageUid($cartPid)
->setNoCache(1);//->setTargetPageType(2000);
        $cartUrl = $cartUriBuilder->build();//uriFor($action, '' );

        $output = $this->renderChildren();
        $class = $this->arguments['class'];
        return '<a href="' . htmlspecialchars(
            $cartUrl
        ) . '"' . ($class ? ' class="' . $class . '"' : '') . '>' . $output . '</a>';
    }
}
