<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use InternetGalerie\Igshop2\Domain\Model\Product;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\HttpUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\Typolink\LinkFactory;
use TYPO3\CMS\Frontend\Typolink\UnableToLinkException;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class ProductViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerUniversalTagAttributes();
        $this->registerArgument('product', Product::class, 'Product', true);
        $this->registerArgument('pageUid', 'int', 'pageUid for show page', false);
        $this->registerArgument(
            'fallbackPageUid',
            'int',
            'fallback pageUid for show page, if not defined in categories',
            false
        );
        $this->registerArgument('absolute', 'bool', 'If set, the URI of the rendered link is absolute');
    }

    public function render(): string
    {
        $request = $this->renderingContext->getRequest();
        $pageUid = (int)($this->arguments['pageUid'] ?? 0);
        $fallbackPageUid = (int)($this->arguments['fallbackPageUid'] ?? 0);
        $product = $this->arguments['product'];
        $absolute = (bool)($this->arguments['absolute'] ?? false);

        if ($pageUid > 0) {
            $targetPageUid = $pageUid;
        } else {
            $targetPageUid = $product->getDetailPageUid();
            if ($targetPageUid === null || $targetPageUid == 0) {
                $targetPageUid = $product->getCategoryDetailPageUid();
                if ($targetPageUid === null || $targetPageUid == 0) {
                    $targetPageUid = $fallbackPageUid;
                }
            }
        }
        
        $typolinkConfiguration = [
            'parameter' => $targetPageUid,
        ];
        $extensionName = 'IgShop2'; //$request->getControllerExtensionName();
        $pluginName = 'FeshopShow';
        $controller = 'Product';
        $action = 'show';
        $arguments = [
            'product' => $product->getUid(),
        ];
        $extbaseArgumentNamespace = 'tx_'
            . str_replace('_', '', strtolower($extensionName))
            . '_'
            . str_replace('_', '', strtolower($pluginName));
        $additionalParams = [];
        $additionalParams[$extbaseArgumentNamespace] = array_replace(
            [
                'controller' => $controller,
                'action' => $action,
            ],
            $arguments
        );
        $typolinkConfiguration['additionalParams'] = HttpUtility::buildQueryString($additionalParams, '&');
        if ($absolute) {
            $typolinkConfiguration['forceAbsoluteUrl'] = true;
        }


        try {
            $cObj = GeneralUtility::makeInstance(ContentObjectRenderer::class);
            $cObj->setRequest($request);
            $linkFactory = GeneralUtility::makeInstance(LinkFactory::class);
            $linkResult = $linkFactory->create((string)$this->renderChildren(), $typolinkConfiguration, $cObj);
            // Removing TypoLink target here to ensure same behaviour with extbase uri builder in this context.
            $linkResultAttributes = $linkResult->getAttributes();
            unset($linkResultAttributes['target']);

            $this->tag->addAttributes($linkResultAttributes);
            $this->tag->setContent($this->renderChildren());
            $this->tag->forceClosingTag(true);
            return $this->tag->render();
        } catch (UnableToLinkException) {
            return (string)$this->renderChildren();
        }
    }
}
