<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Mandant;

use Closure;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ProductsViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'organisation uid', true);
        //$this->registerArgument('pid', 'int', 'organisation uid', true);
        $this->registerArgument('as', 'string', 'name for organisation object ', true);
        $this->registerArgument('keyword', 'string', 'search keyword', false, '');
    }

    /**
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $productRepository = GeneralUtility::makeInstance(ProductRepository::class);
        $mandantUid = $arguments['uid'];
        $keyword = $arguments['keyword'];
        $products = $productRepository->findByMandantUid($mandantUid);
        if ($keyword) {
            $products = $productRepository->findWidthMandantUidAndKeyword($mandantUid, $keyword);
        }

        $templateVariableContainer = $renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $products);

        $output = $renderChildrenClosure();
        $templateVariableContainer->remove($arguments['as']);
        return $output;
    }
}
