<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use InternetGalerie\Igshop2\Domain\Model\AbstractOrderProduct;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Model\OrderProduct;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class ProdOptionsViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        $this->registerArgument(
            'orderProduct',
            AbstractOrderProduct::class,
            'Specifies where to open the linked document',
            true
        );
    }

    /**
     * Returns total price of order, with or without Porto
     *
     * @return mixed
     */
    public function render(): string
    {
        $orderProduct = $this->arguments['orderProduct'];
        return $orderProduct->getOptionsRaw();
    }
}
