<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class UserGroupViewHelper extends AbstractViewHelper
{
    /**
     * Returns true if user is logged in and is an instructor
     *
     * @return boolean
     */
    public function render(): string
    {
        $context = GeneralUtility::makeInstance(Context::class);

        // if not logged in
        if (!$context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            return false;
        }

        // get usergroups from fe_user
        $userGroups = $context->getPropertyFromAspect('frontend.user', 'groupIds');

        // if in one of those groups
        if (array_intersect([10, 11, 12], $userGroups)) {
            return true;
        }

        //else
        return false;
    }
}
