<?php

namespace InternetGalerie\Igshop2\Widgets;

use InternetGalerie\Igshop2\Widgets\Provider\ProductProviderInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;

class ProductWidget implements WidgetInterface, RequestAwareWidgetInterface
{
    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly ProductProviderInterface $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider = null,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }
    
    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/igshop2']);
        $view->assignMultiple([
            'categoriesLimit' => $this->dataProvider->getLimit(),
            'categories' => $this->dataProvider->getCategories(),
            'total' => $this->dataProvider->getProductTotal(),
            'options' => $this->options,
            //'button' => $this->getButton(),
            'configuration' => $this->configuration,
        ]);
        return $view->render('IgShop2/Widget/ProductWidget');
    }

    public function getOptions(): array
    {
        return $this->options;
    }
}
