<?php

declare(strict_types=1);

namespace InternetGalerie\Igshop2\Widgets\Provider;

use InternetGalerie\Igshop2\Domain\Model\Order;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;

class OrderProvider implements OrderProviderInterface
{
    protected DataMapper $dataMapper;

    /**
     * @var int
     */
    private $limit;

    public function __construct(int $limit)
    {
        $this->limit = $limit ?: 10;
    }


    public function injectDataMapper(DataMapper $dataMapper): void
    {
        $this->dataMapper = $dataMapper;
    }

    public function getOrders(): array
    {
        $items = [];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_order'
        );
        $sql = 'SELECT * FROM tx_igshop2_domain_model_order WHERE submitted = 1 ORDER BY crdate DESC LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);

        $res = $res->fetchAllAssociative();

        $obj = $this->dataMapper->map(Order::class, $res);

        return $obj;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }
}
