<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$GLOBALS['TCA']['tx_igshop2_domain_model_property'] = [
	'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'sortby' => 'sorting',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,external_id,category,active,parent,',
        //'dynamicConfigFile' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($_EXTKEY) . 'Configuration/TCA/Category.php',
        'iconfile' => ExtensionManagementUtility::extPath('igshop2') . 'Resources/Public/Icons/tx_igshop2_domain_model_property.gif'
    ],
	'types' => [
		'1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,category,field_type,name,use_in_comparison,show_in_detailpage,show_in_filter,field_name,unit,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,--palette--;;1,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => ['type' => 'language'],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_property',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_property.pid=###CURRENT_PID### AND tx_igshop2_domain_model_property.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],
		'sorting' => [
			'exclude' => 1,
			'l10n_mode' => 'exclude',
			'config' => [
                'type' => 'passthrough'
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

		'name' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.name',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'use_in_comparison' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.use_in_comparison',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => '',
                    ]
                ],
                'default' => 1,
			],
		],
        'show_in_detailpage' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.show_in_detailpage',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ],
                ],
                'default' => 1,
            ],
        ],
        'show_in_filter' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.show_in_filter',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ],
                ],
                'default' => 1,
            ],
        ],
		'field_name' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.field_name',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'unit' => [
			'displayCond' => 'FIELD:field_type:=:Float',
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.unit',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],
		'field_type' => [
			'onChange' => 'reload',
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.field_type',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['label' => 'Text', 'value' => 'Text'],
					['label' => 'Text Mehrzeilig', 'value' => 'Textarea'],
					['label' => 'Richtext', 'value' => 'Rte'],
					['label' => 'Zahl', 'value' => 'Float'],
					['label' => 'Checkbox', 'value' => 'Checkbox'],
				],
			],
		],
		'db_type' => [
			'onChange' => 'reload',
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.db_type',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['label' => 'Text', 'value' => 'property_value'],
					['label' => 'Textarea', 'value' => 'property_value_textarea'],
					['label' => 'Zahl (Gleitkommazahl)', 'value' => 'property_value_number'],
				],
			],
		],
		'partial' => [
			'onChange' => 'reload',
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.partial',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['label' => 'Häkchen', 'value' => 'Checkbox'],
					['label' => 'Text', 'value' => 'Text'],
					['label' => 'Richtext', 'value' => 'Rte'],
					['label' => 'Liste', 'value' => 'List'],
					['label' => 'Zahl', 'value' => 'Float'],
					['label' => 'Externer Link', 'value' => 'ExternalLink'],
				],
			],
		],
		'category' => [
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_property.category',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_propertycategory',
			],
		],

	],
];
