class IgShopReminderListHandler {
    constructor(config) {
        this.linkSelector = '.igshop2-add-to-reminder-list-link',
        this.countWrapperSelector = '.tx-igshop2-reminder-list-small',
        this.countTextSelector = '.igshop-reminder-list-count-text',
        this.linkButtonTextSelector = '.link-button-text',
        this.ajaxLoaderSelector = '.ajax-loader',
        this.linkElement = document.querySelector(this.linkSelector),
        this.countWrapperElement = document.querySelector(this.countWrapperSelector),
        this.countTextElement = this.countWrapperElement ? this.countWrapperElement.querySelector(this.countTextSelector) : null,
        this.linkButtonElement = this.linkElement ? this.linkElement.querySelector(this.linkButtonTextSelector) : null,
        this.ajaxLoaderElement = this.linkElement ? this.linkElement.querySelector(this.ajaxLoaderSelector) : null
    }

    init() {
        if(this.countWrapperElement) {
            this.initProductCount();
        }
        if(this.linkElement) {
            this.linkElement.addEventListener('click', (e) => {
                e.preventDefault();

                this.addProduct();
            });
        }
    }

    initProductCount() {
        let fetchProductsUrl = this.countWrapperElement.dataset.fetchProductsUrl;
        if(fetchProductsUrl) {
            var promise = null;
            var persistedReminderListUid = localStorage.getItem('igshopReminderListUid');
            if(persistedReminderListUid) {
                var requestData = new URLSearchParams({"tx_igshop2_reminderlist[reminderList]": persistedReminderListUid});
                promise = fetch(fetchProductsUrl, {method: 'POST', body: requestData});
            } else {
                promise = fetch(fetchProductsUrl, {method: 'POST'});
            }
            promise.then((response) => {
                return response.json();
            })
            .then((data) => {
                if(data.reminderListUid) {
                    localStorage.setItem('igshopReminderListUid', data.reminderListUid);
                }
                this.updateCount(data.productCount);
            });
        }
    }

    addProduct() {
        let addProductUrl = this.linkElement.href;
        if(addProductUrl) {
            this.showAjaxLoader();
            
            var promise = null;
            var persistedReminderListUid = localStorage.getItem('igshopReminderListUid');
            
            if(persistedReminderListUid) {
                var requestData = new URLSearchParams({"tx_igshop2_reminderlist[reminderList]": persistedReminderListUid});
                promise = fetch(addProductUrl, {method: 'POST', body: requestData});
            } else {
                promise = fetch(addProductUrl, {method: 'POST'});
            }

            promise.then((response) => {
                return response.json();
            })
            .then((data) => {
                if(data.reminderListUid) {
                    localStorage.setItem('igshopReminderListUid', data.reminderListUid);
                }

                this.updateView(data.html);
                this.updateCount(data.productCount);

                this.hideAjaxLoader();
            });
        }
    }

    showAjaxLoader() {
        this.ajaxLoaderElement.style.display = '';
        this.linkButtonElement.style.visibility = 'hidden';
    }

    hideAjaxLoader() {
        this.ajaxLoaderElement.style.display = 'none';
        this.linkButtonElement.style.visibility = '';
    }

    // TODO: Analog zu smallFeCart Liste ausgeben und count aktualisieren
    updateView(html) {
        //console.log(html);

    }

    updateCount(count) {
        if(this.countTextElement) {
            this.countTextElement.textContent = count;
        }
    }
}

let igShopReminderListHandler = new IgShopReminderListHandler({});
igShopReminderListHandler.init();