<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use InternetGalerie\Igshop2\Controller\ProductController;
use InternetGalerie\Igshop2\Controller\OrderController;
use InternetGalerie\Igshop2\Controller\PostFinanceCheckoutController;
use InternetGalerie\Igshop2\Controller\PaymentController;
use InternetGalerie\Igshop2\Controller\PostFinanceController;
use InternetGalerie\Igshop2\Controller\AddressController;
use InternetGalerie\Igshop2\Controller\CategoryController;
use InternetGalerie\Igshop2\Controller\ReminderListController;
use InternetGalerie\Igshop2\Controller\ProductComparisonController;
use InternetGalerie\Igshop2\Routing\Aspect\PersistedAliasMapper;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\BitmapIconProvider;
use InternetGalerie\Igshop2\Form\Element\PropertyFieldsElement;
use TYPO3\CMS\Backend\Form\FormDataProvider\TcaInline;
use InternetGalerie\Igshop2\Hooks\Datahandler\CommandMapPostProcessingHook;
defined('TYPO3') or die();

ExtensionUtility::configurePlugin(
	'Igshop2',
	'Feshop',
	[
		ProductController::class => 'list, show, searchBox, searchResults, showTopProduct, ajaxGetProductPrice, ajaxSearch, searchAjax',

	],
	// non-cacheable actions
	[
		ProductController::class => 'list,searchBox, searchResults, showTopProduct, ajaxGetProductPrice, ajaxSearch, searchAjax',
        //show, list,

	]
);
ExtensionUtility::configurePlugin(
	'Igshop2',
	'FeshopSlider',
	[
		ProductController::class => 'slider',

	],
	// non-cacheable actions
	[
        //show, list,

	]
);
ExtensionUtility::configurePlugin(
	'Igshop2',
	'FeshopShow',
	[
		ProductController::class => 'show',

	],
	// non-cacheable actions
	[
		//'Product' => 'show',

	]
);
ExtensionUtility::configurePlugin(
	'Igshop2',
	'FeshopTopProduct',
	[
		ProductController::class => 'showTopProduct',

	],
	// non-cacheable actions
	[
		//'Product' => 'show',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'Fecart',
	[
        OrderController::class => 'show, addOrderProduct, changeCurrency, editCalcAddress, saveCalcAddress, editAmount, ajaxAddProduct, smallShopAddCart, editAddress, saveAddress, submitPayment, editProduct, addProduct, deleteProduct, review, payPalEnter, payPalThanks, smallFeCart, paymentError',
		PaymentController::class => 'payment, checkTransactionSuccess',

	],
	// non-cacheable actions
	[
		 OrderController::class => 'show, addOrderProduct, changeCurrency, editCalcAddress, saveCalcAddress, editAmount, ajaxAddProduct, smallShopAddCart, editAddress, saveAddress, submitPayment, editProduct, addProduct, deleteProduct, review, payPalEnter, payPalThanks, smallFeCart, paymentError',
		PaymentController::class => 'payment, checkTransactionSuccess',

	]
);

ExtensionUtility::configurePlugin(
    'Igshop2',
    'Prodexport',
    [
        ProductController::class => 'export',

    ],
    // non-cacheable actions
    [
        ProductController::class => 'export',

    ]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'Fecartsmall',
	[
		OrderController::class => 'smallFeCart, loadSmallCartData',

	],
	// non-cacheable actions
	[
		OrderController::class => 'smallFeCart, loadSmallCartData',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'HtmlTitle',
	[
		ProductController::class => 'htmlTitle',

	],
	// non-cacheable actions
	[
		ProductController::class => 'htmlTitle',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'PostFinanceHandler',
	[
		PostFinanceController::class => 'accept, decline, exception, cancel',

	],
	// non-cacheable actions
	[
		PostFinanceController::class => 'accept, decline, exception, cancel',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'Fesearchbox',
	[
		ProductController::class => 'searchBox',

	],
	// non-cacheable actions
	[
		ProductController::class => 'searchBox',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'UserOrderHistory',
	[
		OrderController::class => 'userList, userShow',

	],
	// non-cacheable actions
	[
		OrderController::class => 'userList, userShow',

	]
);

ExtensionUtility::configurePlugin(
    'Igshop2',
    'AddressManagement',
    [
        AddressController::class => 'list, new, create, edit, update, delete',

    ],
    // non-cacheable actions
    [
        AddressController::class => 'list, new, create, edit, update, delete',

    ]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'Categorynav',
	[
		 CategoryController::class => 'categoryNav',
	],
	// non-cacheable actions
	[
		CategoryController::class => 'categoryNav',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'ReminderList',
	[
		ReminderListController::class => 'list,addProduct,fetchProducts,removeProduct',
	],
	// non-cacheable actions
	[
		ReminderListController::class => 'list,addProduct,fetchProducts,removeProduct',

	]
);

ExtensionUtility::configurePlugin(
	'Igshop2',
	'ProductComparison',
	[
		ProductComparisonController::class => 'list,addProduct,fetchProducts,removeProduct',
	],
	// non-cacheable actions
	[
		ProductComparisonController::class => 'list,addProduct,fetchProducts,removeProduct',

	]
);

$GLOBALS['TYPO3_CONF_VARS']['SYS']['routing']['aspects']['ShopPersistedAliasMapper'] = PersistedAliasMapper::class;

/*$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['TYPO3\\CMS\\Recordlist\\RecordList\\DatabaseRecordList']['buildQueryParameters'][]
        = \InternetGalerie\Igshop2\Hooks\Backend\RecordListQueryHook8::class;*/



$iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);
$icons = [
    'igshop2-folder' => ['source' => 'EXT:igshop2/Resources/Public/Icons/folder-module-shop.svg'],
];
$iconProviderClassName = BitmapIconProvider::class;
foreach ($icons as $identifier => $options) {
    $iconRegistry->registerIcon($identifier, $iconProviderClassName, $options);
}


$GLOBALS['TYPO3_CONF_VARS']['SYS']['formEngine']['nodeRegistry'][1689779237] = [
    'nodeName' => 'propertyFields',
    'priority' => 40,
    'class' => PropertyFieldsElement::class,
];


unset($GLOBALS['TYPO3_CONF_VARS']['SYS']['formEngine']['formDataGroup']['tcaDatabaseRecord'][TcaInline::class]);
$GLOBALS['TYPO3_CONF_VARS']['SYS']['formEngine']['formDataGroup']['tcaDatabaseRecord'][\InternetGalerie\Igshop2\Form\FormDataProvider\TcaInline::class] = [
    'depends' => [
        TcaInline::class,
    ],
];



// add hook to move products in category view
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processCmdmapClass'] = array_merge(
    [
        'ig-shop-post-process' =>  CommandMapPostProcessingHook::class,
    ],
    $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processCmdmapClass'] ?? []
);
