<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\Page\PageRenderer;
use FriendsOfTYPO3\TtAddress\Domain\Repository\AddressRepository;
use InternetGalerie\Igshop2\Domain\Model\Address;
use InternetGalerie\Igshop2\Domain\Model\Shop;
use InternetGalerie\Igshop2\Domain\Repository\CountryRepository;
use InternetGalerie\Igshop2\Domain\Repository\FeUserRepository;
use InternetGalerie\Igshop2\Domain\Repository\ShopRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

/**
 * AddressController
 */
class AddressController extends ActionController
{
    protected Shop $shop;

    private $jsRootPath = 'EXT:igshop2/Resources/Public/JavaScript/';

    public function __construct(
        protected AddressRepository $addressRepository,
        protected FeUserRepository $feUserRepository,
        protected CountryRepository $countryRepository,
        protected ShopRepository $shopRepository
    ) {
    }

    public function listAction(string $returnUrl = ''): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
        }

        //DebuggerUtility::var_dump($feUser);
        $this->view->assign('returnUrl', $returnUrl);
        $this->view->assign('feUser', $feUser);

        return $this->htmlResponse();
    }

    public function newAction(string $returnUrl = '', string $addressType = ''): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
        }

        $countries = $this->shop === null ? $this->countryRepository->findAll() : $this->shop->getCountries();
        $this->view->assign('returnUrl', $returnUrl);
        $this->view->assign('addressType', $addressType);
        $this->view->assign('feUser', $feUser);
        $this->view->assign('countries', $countries);
        $this->view->assign('shop', $this->shop);

        return $this->htmlResponse();
    }

    public function createAction(
        Address $newAddress,
        string $returnUrl = '',
        string $addressType = ''
    ): ResponseInterface {
        $newAddress->updateName();
        $this->addressRepository->add($newAddress);

        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
        }

        if ($addressType == '' && !$feUser->getLastUsedAddress()) {
            $persistenceManager->persistAll();
            $feUser->setLastUsedAddress($newAddress);
            $this->feUserRepository->update($feUser);
        } elseif ($addressType !== '') {
            $persistenceManager->persistAll();

            if ($addressType == 'delivery') {
                $feUser->setLastUsedAddress($newAddress);
            } elseif ($addressType == 'billing') {
                $feUser->setLastUsedBillingAddress($newAddress);
            }

            $this->feUserRepository->update($feUser);
        }

        if ($returnUrl !== '') {
            return $this->redirectToUri($returnUrl);
        }

        return $this->redirect('list');
    }

    public function editAction(Address $address, string $returnUrl = ''): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        if ($context->getPropertyFromAspect('frontend.user', 'isLoggedIn')) {
            $feUser = $this->feUserRepository->findByUid($context->getPropertyFromAspect('frontend.user', 'id'));
        }

        $countries = $this->shop === null ? $this->countryRepository->findAll() : $this->shop->getCountries();
        $this->view->assign('address', $address);
        $this->view->assign('returnUrl', $returnUrl);
        $this->view->assign('feUser', $feUser);
        $this->view->assign('countries', $countries);
        $this->view->assign('shop', $this->shop);

        return $this->htmlResponse();
    }

    public function updateAction(Address $address, string $returnUrl = ''): ResponseInterface
    {
        $address->updateName();
        $this->addressRepository->update($address);

        if ($returnUrl !== '') {
            return $this->redirectToUri($returnUrl);
        }

        return $this->redirect('list');
    }

    public function deleteAction(Address $address, string $returnUrl = ''): ResponseInterface
    {
        $this->addressRepository->remove($address);

        if ($returnUrl !== '') {
            return $this->redirectToUri($returnUrl);
        }

        return $this->redirect('list');
    }

    protected function initializeAction(): void
    {
        if ($this->settings['shopUid']) {
            $this->shop = $this->shopRepository->findByUid($this->settings['shopUid']);
        }

        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile($this->jsRootPath . 'Address/igShop_Address.js');
    }
}
