<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Psr\Http\Message\ResponseFactoryInterface;
use TYPO3\CMS\Core\Utility\HttpUtility;
use TYPO3\CMS\Core\Http\PropagateResponseException;
use InternetGalerie\Igshop2\Domain\Model\Category;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\Configuration\BackendUserConfiguration;
use TYPO3\CMS\Backend\Template\ModuleTemplateFactory;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * BackendProductController
 */
class BackendCategoryController extends ActionController
{
    protected ?int $id = 0;

    protected ?int $categoryUid = 0;

    protected string $tableName = 'tx_igshop2_domain_model_category';

    public function __construct(
        protected ModuleTemplateFactory $moduleTemplateFactory,
        protected CategoryRepository $categoryRepository
    ) {
    }

    /**
     * Action index
     */
    public function indexAction(): ResponseInterface
    {
        $moduleTemplate = $this->moduleTemplateFactory->create($this->request);
        if (!is_null($this->id)) {
            if ($this->request->hasArgument('search')) {
                $search = $this->request->getArgument('search');
            } else {
                $search = [];
            }

            if ($this->categoryUid && !isset($search['category'])) {
                $search['category'] = $this->categoryUid;
            }

            $searchParams = [
                'search' => $search,
            ];

            $selectedCategory = null;
            if (isset($search['category']) && $search['category'] != '') {
                $selectedCategory = $this->categoryRepository->findByUidBackend($search['category']);
            }

            if (!isset($search['keywords']) || $search['keywords'] == '') {
                if (!isset($search['category']) || $search['category'] == '') {
                    $search['category'] = '0';
                }
            }

            $categories = $this->categoryRepository->findByPidAndSearchRaw($this->id, $search);
            $this->categoryRepository->setDefaultOrderings([
                'name' => QueryInterface::ORDER_ASCENDING,
            ]);
            $searchCategories = $this->categoryRepository->findByPidAndSearchRaw($this->id, null);


            $tableRows = [];
            $categoryCount = count($categories);

            for ($i = 0;$i < $categoryCount;++$i) {
                $category = $categories[$i];
                $next = ($i + 1 < $categoryCount) ? $i + 1 : 0;
                $prev = $i - 2;

                $tableRow = [
                    'category' => $category,
                ];
                $tableRow['uid'] = $category['uid'];
                // Move up link: If it should move to the top of the list, page uid is used, else the negative uid of the penultimate entry
                $tableRow['moveUp'] = $prev < 0 ? $this->id : -$categories[$prev]['uid']; // bei $i==0 Wert 0?
                // Move down link: Negative uid of the next entry
                $tableRow['moveDown'] = $next ? -$categories[$next]['uid'] : 0;// - $categories[$i]['uid'];
                $tableRows[] = $tableRow;
            }

            if ($selectedCategory) {
                //defVals[$this->tableName][categoryid]=NEWPRODID
                // TCAdefaults.$this->tableName.category=2
                $defVals = [
                    $this->tableName => [
                        'parent' => $selectedCategory->getUid(),
                    ],
                ];
            } else {
                $defVals = [];
            }

            $moduleTemplate->assignMultiple([
                'tableName' => $this->tableName,
                'pageUid' => $this->id,
                'defVals' => $defVals,
                'search' => $search,
                'searchParams' => $searchParams,
                'selectedCategory' => $selectedCategory,
                'categories' => $categories,
                'searchCategories' => $searchCategories,
                'tableRows' => $tableRows,
            ]);
        } else {
            $moduleTemplate->assign('noPidSelected', true);
        }

        return $moduleTemplate->renderResponse('BackendCategory/Index');
    }

    /**
     * Action sortCategorysInCategory
     */
    public function sortCategorysInCategoryAction(): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        if (!$this->request->hasArgument('direction') || !$this->request->hasArgument(
            'category'
        ) || !isset($search['category'])) {
            die('missing arguments, needs: direction, category, selectedCategory');
        }

        $direction = $this->request->getArgument('direction');
        $categoryUid = $this->request->getArgument('category');
        $categoryUid = $search['category'];


        $i = 1;
        $categorys = $this->categoryRepository->findCategoryRelationDoctrine($categoryUid);
        foreach ($categorys as $category) {
            if ($category['uid_local'] == $categoryUid) {
                $category['sorting_foreign'] = $i + ($direction == 'down' ? 3 : -3);
            } else {
                $category['sorting_foreign'] = $i;
            }

            $i += 2;
            $this->categoryRepository->updateCategoryCategorySortingDoctrine($category);
        }

        return $this->redirect('index', null, null, [
            'search' => $search,
        ]);
    }

    /**
     * edit category action
     * @param array $search
     */
    public function newAction($search = []): ResponseInterface
    {
        $this->redirectToEditAction($this->tableName, 'new', $this->id, [], $search);
        return $this->htmlResponse();
    }

    /**
     * new category after category action
     * @param Category|null $category
     * @param array $search
     * @IgnoreValidation
     */
    public function newAfterAction(Category $category, $search = []): ResponseInterface
    {
        $this->redirectToEditAction($this->tableName, 'new', -$category->getUid(), [], $search);
        return $this->htmlResponse();
    }

    /**
     * edit category action
     * @param Category $category
     * @param array $search
     */
    public function editAction($category, $search = []): ResponseInterface
    {
        $this->redirectToEditAction($this->tableName, 'edit', $category->getUid(), [], $search);
        return $this->htmlResponse();
    }

    /**
     * AJAX call to sort categorys in a category
     *
     * @return ResponseInterface
     */
    public function ajaxSortCategorysInCategory(ServerRequestInterface $request, ResponseInterface $response): void
    {
        $data = $request->getParsedBody();
        $identifierArray = explode('-', (string) $data['identifier']);

        $sortList = explode(',', (string) $data['sortList']);
        $categoryUid = $identifierArray[3];

        $i = 1;
        foreach ($sortList as $categoryUid) {
            $category = $this->categoryRepository->findCategoryCategoryRelationDoctrine($categoryUid, $categoryUid);
            $category['sorting_foreign'] = $i++;
            $this->categoryRepository->updateCategoryCategorySortingDoctrine($category);
        }

        die();
    }

    /**
     * Initialize action stores the id
     */
    protected function initializeAction(): void
    {
        /** @var BackendUserConfiguration $backendUserConfiguration */
        $backendUserConfiguration = GeneralUtility::makeInstance(BackendUserConfiguration::class);
        $this->id = $this->request->hasArgument('id') ? (int)$this->request->getArgument('id') : null;
        $this->categoryUid = $this->request->hasArgument('entryId') ? (int)$this->request->getArgument('entryId') : null;

        if ($this->categoryUid === null || $this->id === null) {
            $this->id = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.pageUid');
            $this->categoryUid = (int)$backendUserConfiguration->get('BackendComponents.States.Shop.entryId');
        }

        $backendUserConfiguration->set('BackendComponents.States.Shop.pageUid', $this->id);
        $backendUserConfiguration->set('BackendComponents.States.Shop.entryId', $this->categoryUid);
    }

    /**
     * Redirect to tceform creating a new record
     *
     * @param string $table table name
     * @param string $action
     * @param int $uid
     * @param string $additionalParams
     */
    private function redirectToEditAction(
        $table,
        $action,
        $uid,
        $additionalParams = [],
        $additionalParamsReturnUrl = []
    ): void {
        $params = [
            'edit[' . $table . '][' . $uid . ']' => $action,
            'returnUrl' => $this->getReturnUrl($additionalParamsReturnUrl),
        ];
        foreach ($additionalParams as $key => $value) {
            $params[$key] = $value;
        }

        $url = BackendUtility::getModuleUrl('record_edit', $params);

        $response = GeneralUtility::makeInstance(
            ResponseFactoryInterface::class
        )->createResponse(
            HttpUtility::HTTP_STATUS_303
        )->withAddedHeader(
            'location',
            $url
        );
        throw new PropagateResponseException($response);
    }

    /**
     * Returns the return url
     *
     * @param array $additionalParams
     */
    private function getReturnUrl($additionalParams = [])
    {
        return BackendUtility::getModuleUrl(
            'web_Igshop2Backendcategory',
            ([
                'tx_igshop2_web_igshop2backendcategory' => [
                    'search' => $additionalParams,
                ],
                'id' => $this->id,
            ])
        );
    }
}
