<?php

namespace InternetGalerie\Igshop2\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Ig\IgPayment\Services\PostFinanceService;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;

/**
 * PostFinanceController
 */
class PostFinanceController extends ActionController
{
    protected $vars = [];

    protected PostFinanceService $postFinanceService;

    public function acceptAction(): ResponseInterface
    {
        $action = $this->postFinanceService->getAction(
            $this->settings['postFinance']['shaOut'],
            $this->settings['postFinance']['hashAlgorithm']
        );

        if ($action == 'cancel') {
            return new ForwardResponse($action);
        }

        if ($action == 'exception' || $action == 'decline') {
            return new ForwardResponse('exception');
        }

        return $this->redirect('submitPayment', 'Order', null, [
            'complus' => 1,
            'ordertosubmit' => $this->vars['ORDERID'],
        ], $this->settings['cartPid']);
        //$this->redirectToUri('produkte-online-shop/warenkorb.html?tx_igshop2_fecart[action]=submitPayment&tx_igshop2_fecart[complus]=1&tx_igshop2_fecart[ordertosubmit]='.$this->vars['ORDERID']);
    }

    public function exceptionAction(): ResponseInterface
    {
        $this->view->assign('params', $this->vars);

        return $this->htmlResponse();
    }

    public function cancelAction(): ResponseInterface
    {
        $this->view->assign('params', $this->vars);
        return $this->htmlResponse();
    }

    protected function initializeAction(): void
    {
        $this->postFinanceService = GeneralUtility::makeInstance(PostFinanceService::class);
        $this->vars = $this->postFinanceService->getVars();
    }
}
