<?php

namespace InternetGalerie\Igshop2\Controller;

use InternetGalerie\Igshop2\Domain\Model\Product;
use InternetGalerie\Igshop2\Domain\Model\ReminderList;
use InternetGalerie\Igshop2\Domain\Repository\FeUserRepository;
use InternetGalerie\Igshop2\Domain\Repository\ReminderListRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

/**
 * ReminderListController
 */
class ReminderListController extends ActionController
{
    protected ?ReminderList $reminderList = null;

    public function __construct(
        protected ReminderListRepository $reminderListRepository,
        protected FeUserRepository $feUserRepository
    ) {
    }

    public function listAction(): ResponseInterface
    {
        $this->view->assign('reminderList', $this->reminderList);

        return $this->htmlResponse();
    }

    public function addProductAction(Product $product): ResponseInterface
    {
        $data = [];

        if ($this->reminderList->hasProduct($product)) {
            $data['status'] = 'already-in-list';
        } else {
            $this->reminderList->addProduct($product);
            $this->reminderListRepository->update($this->reminderList);
            $data['status'] = 'success';
        }

        $this->view->assign('reminderList', $this->reminderList);

        $data['reminderListUid'] = $this->reminderList->getUid();
        $data['productCount'] = $this->reminderList->getProducts()->count();
        $data['html'] = $this->view->render();

        return $this->jsonResponse(json_encode($data));
    }

    public function fetchProductsAction(): ResponseInterface
    {
        $data = [
            'status' => 'success',
            'reminderListUid' => $this->reminderList->getUid(),
            'productCount' => $this->reminderList->getProducts()
->count(),
            'html' => $this->view->render(),
        ];
        return $this->jsonResponse(json_encode($data));
    }

    public function removeProductAction(Product $product): ResponseInterface
    {
        if ($this->reminderList->hasProduct($product)) {
            $this->reminderList->removeProduct($product);
            $this->reminderListRepository->update($this->reminderList);
        }

        return $this->redirect('list');
    }

    protected function initializeAction(): void
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $feUserId = $context->getPropertyFromAspect('frontend.user', 'id');
        $feUser = null;

        if ($feUserId) {
            $feUser = $this->feUserRepository->findByUid($feUserId);
        }

        $reminderListUid = null;
        if ($this->request->hasArgument('reminderList')) {
            $reminderListUid = $this->request->getArgument('reminderList');
        }
        
        $this->reminderList = $this->reminderListRepository->getCurrentReminderList($reminderListUid, $feUser);
    }
}
