<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * Category
 */
class Category extends AbstractEntity
{
    /**
     * hidden
     *
     * @var bool
     */
    protected $hidden = false;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * description
     *
     * @var string
     */
    protected $teaser = '';

    /**
     * externalId
     *
     * @var string
     */
    protected $externalId = '';

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;


    /**
     * active
     *
     * @var boolean
     */
    protected $active = false;

    /**
     * withoutPorto
     *
     * @var boolean
     */
    protected $withoutPorto = false;

    /**
     * hideInNavigation
     *
     * @var boolean
     */
    protected $hideInNavigation = false;

    /**
     * excludeSlug
     *
     * @var boolean
     */
    protected $excludeSlug = false;

    /**
     * Parent ID
     *
     * @var \InternetGalerie\Igshop2\Domain\Model\Category
     */
    protected $parent = null;

    /**
     * Parent ID
     *
     * @var CategoryView
     */
    protected $view = null;

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     * @Lazy
     * @Cascade
     */
    protected $image = null;

    /**
     * detail page uid
     *
     * @var int
     */
    protected $listPageUid = 0;

    /**
     * detail page uid
     *
     * @var int
     */
    protected $detailPageUid = 0;


    /**
     * image
     *
     * @var ObjectStorage<Property>
     * @Lazy
     */
    protected ?ObjectStorage $properties = null;

    /**
     * products
     *
     * var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\Product>
     * TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    //protected $products = null;

    //protected $subcategories = null;

    public function __construct()
    {
        //$this->products = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->subcategories = null;
        $this->image = new ObjectStorage();
        $this->properties = new ObjectStorage();
    }

    /**
     * Returns the hidden
     *
     * @return bool
     */
    public function getHidden()
    {
        return $this->hidden;
    }

    /**
     * Sets the hidden
     *
     * @param bool $hidden
     */
    public function setHidden($hidden): void
    {
        $this->hidden = $hidden;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }


    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the teaser
     *
     * @return string
     */
    public function getTeaser()
    {
        return $this->teaser;
    }

    /**
     * Sets the teaser
     *
     * @param string $teaser
     */
    public function setTeaser($teaser): void
    {
        $this->teaser = $teaser;
    }

    /**
     * Returns the externalId
     *
     * @return string
     */
    public function getExternalId()
    {
        return $this->externalId;
    }

    /**
     * Sets the externalId
     *
     * @param string $externalId
     */
    public function setExternalId($externalId): void
    {
        $this->externalId = $externalId;
    }

    /**
     * Returns the active
     *
     * @return boolean
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Sets the active
     *
     * @param boolean $active
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     *
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * Returns the withoutPorto
     *
     * @return boolean
     */
    public function getWithoutPorto()
    {
        return $this->withoutPorto;
    }

    /**
     * Sets the withoutPorto
     *
     * @param boolean $withoutPorto
     */
    public function setWithoutPorto($withoutPorto): void
    {
        $this->withoutPorto = $withoutPorto;
    }

    /**
     * Returns the boolean state of withoutPorto
     *
     * @return boolean
     */
    public function isWithoutPorto()
    {
        return $this->withoutPorto;
    }

    /**
     * Returns the hideInNavigation
     *
     * @return boolean
     */
    public function getHideInNavigation()
    {
        return $this->withoutPorto;
    }

    /**
     * Sets the hideInNavigation
     *
     * @param boolean $hideInNavigation
     */
    public function setHideInNavigation($hideInNavigation): void
    {
        $this->hideInNavigation = $hideInNavigation;
    }

    /**
     * Returns the boolean state of hideInNavigation
     *
     * @return boolean
     */
    public function isHideInNavigation()
    {
        return $this->hideInNavigation;
    }

    /**
     * Returns the excludeSlug
     *
     * @return boolean
     */
    public function getExcludeSlug()
    {
        return $this->excludeSlug;
    }

    /**
     * Sets the excludeSlug
     *
     * @param boolean $excludeSlug
     */
    public function setExcludeSlug($excludeSlug): void
    {
        $this->excludeSlug = $excludeSlug;
    }

    /**
     * Returns the boolean state of excludeSlug
     *
     * @return boolean
     */
    public function isExcludeSlug()
    {
        return $this->excludeSlug;
    }

    /**
     * Returns the parent
     *
     * @return \InternetGalerie\Igshop2\Domain\Model\Category
     */
    public function getParent()
    {
        return $this->parent;
    }

    public function getRealParent()
    {
        if ($this->parent instanceof LazyLoadingProxy) {
            $this->parent->_loadRealInstance();
        }

        return $this->parent;
    }

    public function getTopCategory()
    {
        return $this->parent ? $this->parent->getTopCategory() : $this;
    }

    /**
     * Sets the parent
     */
    public function setParent(self $parent): void
    {
        $this->parent = $parent;
    }

    /**
     * @param int $_languageUid
     */
    public function set_languageUid($_languageUid): void
    {
        $this->_languageUid = $_languageUid;
    }

    /**
     * @return int
     */
    public function get_languageUid()
    {
        return $this->_languageUid;
    }

    /**
     * @param int $_localizedUid
     */
    public function set_localizedUid($_localizedUid): void
    {
        $this->_localizedUid = $_localizedUid;
    }

    /**
     * @return int
     */
    public function get_localizedUid()
    {
        return $this->_localizedUid;
    }


    public function getSubcategories()
    {
        if (!$this->subcategories) {
            $categoryRepository = GeneralUtility::makeInstance(CategoryRepository::class);
            $this->subcategories = $categoryRepository->findByParent($this);
        }

        return $this->subcategories;
    }

    public function getFirstLetter()
    {
        return $this->getName()[0];
    }

    /**
     * Returns the view
     *
     * @return CategoryView
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * Sets the view
     */
    public function setView(CategoryView $view): void
    {
        $this->view = $view;
    }

    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Returns the imageLocalized
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImageLocalized()
    {
        //return $this->getImage();
        return $this->getLocalized('image');
    }

    /**
     * Returns the mainimage
     *
     * @return FileReference
     */
    public function getMainImageLocalized()
    {
        $imgs = $this->getImageLocalized();
        return count($imgs) > 0 ? $imgs[0] : null;
    }


    /**
     * Sets the image
     *
     * @param ObjectStorage<FileReference> $image
     */
    public function setImage(ObjectStorage $image): void
    {
        $this->image = $image;
    }

    /**
     * Get the value of detail page uid
     *
     * @return int
     */
    public function getDetailPageUid()
    {
        return $this->detailPageUid;
    }

    /**
     * Set the value of detail page uid
     *
     * @param int $detailPageUid
     *
     * @return self
     */
    public function setDetailPageUid($detailPageUid)
    {
        $this->detailPageUid = $detailPageUid;

        return $this;
    }


    /**
     * Get the value of detail page uid
     *
     * @return int
     */
    public function getListPageUid()
    {
        return $this->listPageUid;
    }

    /**
     * Set the value of detail page uid
     *
     * @param int $listPageUid
     *
     * @return self
     */
    public function setListPageUid($listPageUid)
    {
        $this->listPageUid = $listPageUid;

        return $this;
    }

    /**
     * Adds a Product
     */
    /*
    public function addProduct(\InternetGalerie\Igshop2\Domain\Model\Product $product) {
        $this->products->attach($product);
    }
    */
    /**
     * Removes a Product
     */
    /*
    public function removeProduct(\InternetGalerie\Igshop2\Domain\Model\Product $product) {
        $this->products->detach($product);
    }
    */
    /**
     * Returns the products
     *
     * @return ObjectStorage<Product> $products
     */
    /*
      public function getProducts() {
        return $this->products;
    }
    */
    public function getProducts()
    {
        if ($this->products === null) {
            $this->productRepository = GeneralUtility::makeInstance(ProductRepository::class);
            $this->products = $this->productRepository->findByCategories([$this]);
        }

        return $this->products;
    }

    /**/
    public function getProductsCount()
    {
        if ($this->productsCount === null) {
            $this->productsCount = count($this->getProducts());
        }

        return $this->productsCount;
    }

    public function setProductsCount($productsCount): void
    {
        $this->productsCount = $productsCount;
    }

    public function getProductLink()
    {
        if ($this->productLink === null && $this->getProducts()->count() == 1) {
            $this->productLink = $this->getProducts()
->offsetGet(0)
->getUid();
        }

        return $this->productLink;
    }

    public function setProductLink($productLink): void
    {
        $this->productLink = $productLink;
    }

    /**
     * Sets the products
     *
     * @param ObjectStorage<Product> $products
     */
    public function setProducts(ObjectStorage $products): void
    {
        $this->products = $products;
    }

    public function setProperties(ObjectStorage $properties): void
    {
        $this->properties = $properties;
    }

    public function getProperties(): ?ObjectStorage
    {
        return $this->properties;
    }

    public function addProperty(Property $property): void
    {
        $this->properties->attach($property);
    }

    public function hasProperty(Property $property)
    {
        return $this->properties->contains($property);
    }

    public function removeProperty(Property $property): void
    {
        $this->properties->detach($property);
    }
}
