<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
/**
 * DeliveryPeriod
 */
class DeliveryPeriod extends AbstractEntity
{
    /**
     * onStock
     *
     * @var boolean
     */
    protected $onStock = false;

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * priority
     *
     * @var int
     */
    protected $priority = 0;

    protected ?int $minHandlingTime = null;
    protected ?int $maxHandlingTime = null;

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    public function getMinHandlingTime(): ?int
    {
        return $this->minHandlingTime;
    }

    public function setMinHandlingTime(?int $minHandlingTime): void
    {
        $this->minHandlingTime = $minHandlingTime;
    }

    public function getMaxHandlingTime(): ?int
    {
        return $this->maxHandlingTime;
    }

    public function setMaxHandlingTime(?int $maxHandlingTime): void
    {
        $this->maxHandlingTime = $maxHandlingTime;
    }

    public function getPriority(): int
    {
        return $this->priority;
    }

    public function setPriority(int $priority): void
    {
        $this->priority = $priority;
    }

    /**
     * Returns the onStock
     *
     * @return boolean
     */
    public function getOnStock()
    {
        return $this->onStock;
    }

    /**
     * Sets the onStock
     *
     * @param boolean $onStock
     */
    public function setOnStock($onStock): void
    {
        $this->onStock = $onStock;
    }
}
