<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2015
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * ProductClass
 */
class ProductClass extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * externalId
     *
     * @var string
     */
    protected $externalId = '';

    /**
     * category
     *
     * @var string
     */
    protected $category = '';

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;


    /**
     * active
     *
     * @var boolean
     */
    protected $active = false;

    /**
     * withoutPorto
     *
     * @var boolean
     */
    protected $withoutPorto = false;

    /**
     * hideInNavigation
     *
     * @var boolean
     */
    protected $hideInNavigation = false;

    /**
     * Parent ID
     *
     * @var \InternetGalerie\Igshop2\Domain\Model\ProductClass
     * @Lazy
     */
    protected $parent = null;

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }


    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the externalId
     *
     * @return string
     */
    public function getExternalId()
    {
        return $this->externalId;
    }

    /**
     * Sets the externalId
     *
     * @param string $externalId
     */
    public function setExternalId($externalId): void
    {
        $this->externalId = $externalId;
    }

    /**
     * Returns the category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * Sets the category
     *
     * @param string $category
     */
    public function setCategory($category): void
    {
        $this->category = $category;
    }

    /**
     * Returns the active
     *
     * @return boolean
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Sets the active
     *
     * @param boolean $active
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     *
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * Returns the withoutPorto
     *
     * @return boolean
     */
    public function getWithoutPorto()
    {
        return $this->withoutPorto;
    }

    /**
     * Sets the withoutPorto
     *
     * @param boolean $withoutPorto
     */
    public function setWithoutPorto($withoutPorto): void
    {
        $this->withoutPorto = $withoutPorto;
    }

    /**
     * Returns the boolean state of withoutPorto
     *
     * @return boolean
     */
    public function isWithoutPorto()
    {
        return $this->withoutPorto;
    }

    /**
     * Returns the hideInNavigation
     *
     * @return boolean
     */
    public function getHideInNavigation()
    {
        return $this->withoutPorto;
    }

    /**
     * Sets the hideInNavigation
     *
     * @param boolean $hideInNavigation
     */
    public function setHideInNavigation($hideInNavigation): void
    {
        $this->hideInNavigation = $hideInNavigation;
    }

    /**
     * Returns the boolean state of hideInNavigation
     *
     * @return boolean
     */
    public function isHideInNavigation()
    {
        return $this->hideInNavigation;
    }

    /**
     * Returns the parent
     *
     * @return \InternetGalerie\Igshop2\Domain\Model\ProductClass
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Sets the parent
     */
    public function setParent(self $parent): void
    {
        $this->parent = $parent;
    }

    /**
     * @param int $_languageUid
     */
    public function set_languageUid($_languageUid): void
    {
        $this->_languageUid = $_languageUid;
    }

    /**
     * @return int
     */
    public function get_languageUid()
    {
        return $this->_languageUid;
    }

    /**
     * @param int $_localizedUid
     */
    public function set_localizedUid($_localizedUid): void
    {
        $this->_localizedUid = $_localizedUid;
    }

    /**
     * @return int
     */
    public function get_localizedUid()
    {
        return $this->_localizedUid;
    }

    public function getProducts()
    {
        $productRepository = GeneralUtility::makeInstance(ProductRepository::class);
        return $productRepository->findByProductClass($this);
    }
}
