<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "Ig Shop" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019
 *
 ***/
/**
 * ProductComparison
 */
class ProductComparison extends AbstractEntity
{
    protected ?FeUser $user = null;

    /**
     * products
     *
     * @var ObjectStorage<Product>
     * @Cascade
     * @Lazy
     */
    protected ObjectStorage $products;
    

    public function __construct()
    {
        $this->initStorageObjects();
    }

    public function getUser(): ?FeUser
    {
        return $this->user;
    }

    public function setUser(?FeUser $user): void
    {
        $this->user = $user;
    }

    public function getProducts(): ObjectStorage
    {
        return $this->products;
    }

    public function setProducts(ObjectStorage $products): void
    {
        $this->products = $products;
    }

    public function addProduct(Product $product): void
    {
        $this->products->attach($product);
    }

    public function removeProduct(Product $product): void
    {
        $this->products->detach($product);
    }

    public function removeAllProducts(): void
    {
        foreach ($this->getProducts() as $product) {
            $this->removeProduct($product);
        }
    }

    public function hasProduct(Product $product): bool
    {
        return $this->products->contains($product);
    }

    public function getAllProperties()
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igshop2_domain_model_property'
        );

        $productUids = [];
        foreach ($this->getProducts() as $product) {
            $productUids[] = $product->getUid();
        }

        $properties = $queryBuilder->select('prop.*', 'cat.uid AS catuid', 'cat.name AS catname')
                                   ->from('tx_igshop2_domain_model_property', 'prop')
                                   ->leftJoin(
                                       'prop',
                                       'tx_igshop2_domain_model_propertyvalue',
                                       'val',
                                       'prop.uid = val.property'
                                   )
                                   ->leftJoin(
                                       'prop',
                                       'tx_igshop2_domain_model_propertycategory',
                                       'cat',
                                       'cat.uid = prop.category'
                                   )
                                   ->where(
                                       $queryBuilder->expr()
->in('val.product', $productUids),
                                       'use_in_comparison = 1',
                                   )
                                   ->orderBy('cat.sorting')
                                   ->addOrderBy('prop.sorting')
                                   ->executeQuery()
                                   ->fetchAllAssociative();
        $propertiesByCategory = [];
        foreach ($properties as $property) {
            $catuid = $property['catuid'];
            if (!isset($propertiesByCategory[$catuid])) {
                $propertiesByCategory[$catuid] = [
                    'category' => [
                        'uid' => (int)$catuid,
                        'name' => $property['catname'],
                    ],
                    'properties' => [],
                ];
            }

            $propertiesByCategory[$catuid]['properties'][] = $property;
        }

        return $propertiesByCategory;
        //return $properties;
    }

    public function getPropertyvaluesByProductAndProperties()
    {
        //$properties = $this->getAllProperties();
        $propertiesByCategory = $this->getAllProperties();

        $propertyvaluesByProductAndPropertiesWithCategory = [];
        foreach ($propertiesByCategory as $catuid => $propertiesCategory) {
            $propertyvaluesByProductAndProperties = [];
            foreach ($propertiesCategory['properties'] as $property) {
                $propertyvaluesByProductAndProperties[$property['uid']] = [
                    'property' => $property,
                    'products' => [],
                ];
                foreach ($this->getProducts() as $product) {
                    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                        'tx_igshop2_domain_model_propertyvalue'
                    );
                    $propertyvalue = $queryBuilder->select('val.*')
                                                  ->from('tx_igshop2_domain_model_propertyvalue', 'val')
                                                  ->where($queryBuilder->expr()->eq('val.product', $product->getUid()))
                                                  ->andWhere(
                                                      $queryBuilder->expr()
->eq('val.property', $property['uid'])
                                                  )
                                                  ->executeQuery()
                                                  ->fetchAssociative();

                    if (is_array($propertyvalue)) {
                        $valueFieldName = $this->getValueFieldName($property);
                        $propertyvalue['value'] = $propertyvalue[$valueFieldName];
                    }


                    $propertyvaluesByProductAndProperties[$property['uid']]['products'][$product->getUid()] = [
                        'product' => $product,
                        'propertyvalue' => $propertyvalue ?: null,
                    ];
                }
            }

            $propertyvaluesByProductAndPropertiesWithCategory[] = [
                'category' => $propertiesCategory['category'],
                'propertyvaluesByProductAndProperties' => $propertyvaluesByProductAndProperties,
            ];
        }

        return $propertyvaluesByProductAndPropertiesWithCategory;
        //return $propertyvaluesByProductAndProperties;
    }

    protected function initStorageObjects(): void
    {
        $this->products = new ObjectStorage();
    }

    protected function getValueFieldName($property)
    {
        return match ($property['field_type']) {
            'Checkbox', 'Float' => 'property_value_number',
            'Textarea', 'Rte' => 'property_value_textarea',
            default => 'property_value',
        };
    }
}
