<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use DateTime;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Shipping extends AbstractEntity
{
    protected string $name = '';
    protected ?ShippingService $service = null;
    protected float $price = 0.0;
    protected ?Currency $currency = null;
    protected ?float $minPrice = null;
    protected ?float $maxPrice = null;
    protected ?int $minQuantity = null;
    protected ?int $maxQuantity = null;
    protected ?float $minWeight = null;
    protected ?float $maxWeight = null;
    protected string $shippingLabel = '';
    protected ?float $minLength = null;
    protected ?float $maxLength = null;
    protected ?float $minWidth = null;
    protected ?float $maxWidth = null;
    protected ?float $minHeight = null;
    protected ?float $maxHeight = null;
    protected ?Country $country = null;
    protected ?DateTime $cutoffTime = null;
    protected ?int $minHandlingTime = null;
    protected ?int $maxHandlingTime = null;
    protected ?int $minTransitTime = null;
    protected ?int $maxTransitTime = null;
    protected ?ObjectStorage $shippingLabels = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    protected function initStorageObjects()
    {
        $this->shippingLabels = new ObjectStorage();
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getService(): ?ShippingService
    {
        return $this->service;
    }

    public function setService(?ShippingService $service): void
    {
        $this->service = $service;
    }

    public function getPrice(): float
    {
        return $this->price;
    }

    public function setPrice(float $price): void
    {
        $this->price = $price;
    }

    public function getCurrency(): ?Currency
    {
        return $this->currency;
    }

    public function setCurrency(?Currency $currency): void
    {
        $this->currency = $currency;
    }

    public function getMinPrice(): ?float
    {
        return $this->minPrice;
    }

    public function setMinPrice(?float $minPrice): void
    {
        $this->minPrice = $minPrice;
    }

    public function getMaxPrice(): ?float
    {
        return $this->maxPrice;
    }

    public function setMaxPrice(?float $maxPrice): void
    {
        $this->maxPrice = $maxPrice;
    }

    public function getMinQuantity(): ?int
    {
        return $this->minQuantity;
    }

    public function setMinQuantity(?int $minQuantity): void
    {
        $this->minQuantity = $minQuantity;
    }

    public function getMaxQuantity(): ?int
    {
        return $this->maxQuantity;
    }

    public function setMaxQuantity(?int $maxQuantity): void
    {
        $this->maxQuantity = $maxQuantity;
    }

    public function getMinWeight(): ?float
    {
        return $this->minWeight;
    }

    public function setMinWeight(?float $minWeight): void
    {
        $this->minWeight = $minWeight;
    }

    public function getMaxWeight(): ?float
    {
        return $this->maxWeight;
    }

    public function setMaxWeight(?float $maxWeight): void
    {
        $this->maxWeight = $maxWeight;
    }

    public function getShippingLabel(): string
    {
        return $this->shippingLabel;
    }

    public function setShippingLabel(string $shippingLabel): void
    {
        $this->shippingLabel = $shippingLabel;
    }

    public function getMinLength(): ?float
    {
        return $this->minLength;
    }

    public function setMinLength(?float $minLength): void
    {
        $this->minLength = $minLength;
    }

    public function getMaxLength(): ?float
    {
        return $this->maxLength;
    }

    public function setMaxLength(?float $maxLength): void
    {
        $this->maxLength = $maxLength;
    }

    public function getMinWidth(): ?float
    {
        return $this->minWidth;
    }

    public function setMinWidth(?float $minWidth): void
    {
        $this->minWidth = $minWidth;
    }

    public function getMaxWidth(): ?float
    {
        return $this->maxWidth;
    }

    public function setMaxWidth(?float $maxWidth): void
    {
        $this->maxWidth = $maxWidth;
    }

    public function getMinHeight(): ?float
    {
        return $this->minHeight;
    }

    public function setMinHeight(?float $minHeight): void
    {
        $this->minHeight = $minHeight;
    }

    public function getMaxHeight(): ?float
    {
        return $this->maxHeight;
    }

    public function setMaxHeight(?float $maxHeight): void
    {
        $this->maxHeight = $maxHeight;
    }

    public function getCountry(): ?Country
    {
        return $this->country;
    }

    public function setCountry(?Country $country): void
    {
        $this->country = $country;
    }

    public function getCutoffTime(): ?DateTime
    {
        return $this->cutoffTime;
    }

    public function setCutoffTime(?DateTime $cutoffTime): void
    {
        $this->cutoffTime = $cutoffTime;
    }

    public function getMinHandlingTime(): ?int
    {
        return $this->minHandlingTime;
    }

    public function setMinHandlingTime(?int $minHandlingTime): void
    {
        $this->minHandlingTime = $minHandlingTime;
    }

    public function getMaxHandlingTime(): ?int
    {
        return $this->maxHandlingTime;
    }

    public function setMaxHandlingTime(?int $maxHandlingTime): void
    {
        $this->maxHandlingTime = $maxHandlingTime;
    }

    public function getMinTransitTime(): ?int
    {
        return $this->minTransitTime;
    }

    public function setMinTransitTime(?int $minTransitTime): void
    {
        $this->minTransitTime = $minTransitTime;
    }

    public function getMaxTransitTime(): ?int
    {
        return $this->maxTransitTime;
    }

    public function setMaxTransitTime(?int $maxTransitTime): void
    {
        $this->maxTransitTime = $maxTransitTime;
    }

    public function addShippingLabel(ShippingLabel $shippingLabel): void
    {
        $this->shippingLabels->attach($shippingLabel);
    }

    public function removeShippingLabel(ShippingLabel $shippingLabel): void
    {
        $this->shippingLabels->detach($shippingLabel);
    }

    /**
     * Returns the shippingLabels
     *
     * @return ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\ShippingLabel> $shippingLabel
     */
    public function getShippingLabels(): ObjectStorage
    {
        return $this->shippingLabels;
    }

    /**
     * Sets the shippingLabels
     *
     * @param ObjectStorage<\InternetGalerie\Igshop2\Domain\Model\ShippingLabel> $shippingLabel
     */
    public function setShippingLabels(ObjectStorage $shippingLabel): void
    {
        $this->shippingLabels = $shippingLabel;
    }
}

