<?php

namespace InternetGalerie\Igshop2\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2015
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * Video
 */
class Video extends AbstractEntity
{
    /**
     * video
     *
     * @var FileReference
     * @Lazy
     */
    protected $video = null;

    /**
     * thumb
     *
     * @var FileReference
     * @Lazy
     */
    protected $thumb = null;

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;
    
    /**
     * youtubeVideo
     *
     * @var string
     */
    protected $youtubeVideo = '';

    /**
     * Returns the video
     *
     * @return FileReference
     */
    public function getVideo()
    {
        return $this->video;
    }

    /**
     * Sets the video
     */
    public function setVideo(FileReference $video): void
    {
        $this->video = $video;
    }

    /**
     * Returns the thumb
     *
     * @return FileReference
     */
    public function getThumb()
    {
        return $this->thumb;
    }

    /**
     * Sets the thumb
     */
    public function setThumb(FileReference $thumb): void
    {
        $this->thumb = $thumb;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }
    
    /**
     * Returns the youtubeVideo
     *
     * @return string
     */
    public function getYoutubeVideo()
    {
        return $this->youtubeVideo;
    }

    /**
     * Sets the youtubeVideo
     *
     * @param string $youtubeVideo
     */
    public function setYoutubeVideo($youtubeVideo): void
    {
        $this->youtubeVideo = $youtubeVideo;
    }
}
