<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use Doctrine\DBAL\ParameterType;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for Carts
 */
class CartRepository extends AbstractOrderRepository
{
    protected string $sessionName = 'shopCart';

    public function getTotalProductsAmount($orderUid): int
    {
        $total = 0;
        $qb = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_cartproduct');
        $total = $qb->selectLiteral('SUM(op.amount) AS sum_amount')
            ->from('tx_igshop2_domain_model_cartproduct', 'op')
            ->where(
                $qb->expr()->eq('tx_order', $qb->createNamedParameter($orderUid, ParameterType::INTEGER))
            )
            ->executeQuery()
            ->fetchAssociative();

        return $total['sum_amount'];
    }
}
