<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use Doctrine\DBAL\ParameterType;
use TYPO3\CMS\Extbase\Persistence\Repository;
use InternetGalerie\Igshop2\Utility\RankingUtility;
use InternetGalerie\Igshop2\Domain\Model\Category;
use PDO;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Context\LanguageAspect;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Storage\Typo3DbQueryParser;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Orders
 */
class CategoryRepository extends Repository
{
    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
    ];

    public function __construct(
        protected Typo3DbQueryParser $queryParser,
    ) {
        parent::__construct();
    }

    public function setDefaultOrderings($defaultOrderings): void
    {
        $this->defaultOrderings = $defaultOrderings;
    }

    public function findBySearch($searchword = '', $limit = 0)
    {
        $query = $this->createQuery();

        $rankingCase = '';

        if ($searchword) {
            $searchArray = explode(' ', (string) $searchword);
            $constraints = [];

            foreach ($searchArray as $index => $word) {
                $c = [];
                $c[] = $query->like('name', '%' . $word . '%');
                $c[] = $query->like('parent.name', '%' . $word . '%');
                //$c[] = $query->like('products.name', '%' . $word . '%');
                //$c[] = $query->like('parent.parent.name', '%' . $word . '%');

                $constraints[] = $query->logicalOr(...$c);

                if (strlen($word) >= 3) {
                    $rankingCase .= ($index > 0 ? ' + ' : '') . RankingUtility::getRankingCase(
                        'tx_igshop2_domain_model_category',
                        'name',
                        $word
                    );
                    $rankingCase .= " + CASE WHEN tx_igshop2_domain_model_category0.name LIKE '%" . $word . "%' THEN 4 ELSE 0 END";
                }
            }

            $query->matching($query->logicalAnd(...$constraints));
        }

        $queryBuilder = $this->queryParser->convertQueryToDoctrineQueryBuilder($query);

        if ($rankingCase) {
            $queryBuilder->add('orderBy', $rankingCase . ' DESC, sorting ASC');
        }

        if ($limit) {
            $queryBuilder->setMaxResults($limit);
        }

        return $queryBuilder
            ->executeQuery()
            ->fetchAllAssociative();
    }

    public function findAllWithProductsRaw($mandantUid = null)
    {
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();
        //$querySettings->setLanguageOverlayMode(true);

        //$q->statement('SELECT DISTINCT uid_foreign from tx_igshop2_product_category_mm JOIN tx_igshop2_domain_model_product ON sys_language_uid=2 AND (uid_local=tx_igshop2_domain_model_product.l10n_parent OR uid_local=tx_igshop2_domain_model_product.uid) WHERE deleted=0 AND hidden=0 AND pid IN (' . implode(',', $querySettings->getStoragePageIds()) . ')');

        $sqlWhere = 'tx_igshop2_domain_model_category.deleted=0 AND tx_igshop2_domain_model_category.hidden=0 AND tx_igshop2_domain_model_product.pid IN (' . implode(
            ',',
            $querySettings->getStoragePageIds()
        ) . ')';
        if ($mandantUid > 0) {
            $sqlWhere .= ' AND tx_igshop2_domain_model_product.mandant_uid=' . intval($mandantUid);
        }

        // Alle Kateogrien mit Produkten
        $q = $this->createQuery();
        //tx_igshop2_domain_model_product.pid=4205 AND tx_igshop2_domain_model_category.deleted=0 AND tx_igshop2_domain_model_category.hidden=0 AND  tx_igshop2_domain_model_product.mandant_uid=11683
        $q->statement(
            'SELECT tx_igshop2_domain_model_category.name,tx_igshop2_domain_model_category.uid,tx_igshop2_domain_model_category.parent,SUM(1) as productscount from tx_igshop2_domain_model_category JOIN tx_igshop2_product_category_mm ON tx_igshop2_domain_model_category.uid=uid_foreign JOIN tx_igshop2_domain_model_product ON tx_igshop2_domain_model_product.uid=uid_local AND tx_igshop2_domain_model_product.deleted=0 AND tx_igshop2_domain_model_product.hidden=0 WHERE ' . $sqlWhere . ' GROUP BY  tx_igshop2_domain_model_category.name,tx_igshop2_domain_model_category.uid,tx_igshop2_domain_model_category.parent order by tx_igshop2_domain_model_category.name'
        );

        return $q->execute(true);

        // entspricht am schluss
        //
    }

    public function findAllWithProducts($mandantUid = null)
    {
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();
        //$querySettings->setLanguageOverlayMode(true);

        //$q->statement('SELECT DISTINCT uid_foreign from tx_igshop2_product_category_mm JOIN tx_igshop2_domain_model_product ON sys_language_uid=2 AND (uid_local=tx_igshop2_domain_model_product.l10n_parent OR uid_local=tx_igshop2_domain_model_product.uid) WHERE deleted=0 AND hidden=0 AND pid IN (' . implode(',', $querySettings->getStoragePageIds()) . ')');

        $sqlWhere = 'deleted=0 AND hidden=0 AND pid IN (' . implode(
            ',',
            $querySettings->getStoragePageIds()
        ) . ')';
        if ($mandantUid > 0) {
            $sqlWhere .= ' AND mandant_uid=' . (int)$mandantUid;
        }

        /** @var LanguageAspect */
        $languageAspect = $querySettings->getLanguageAspect();

        // Alle Kateogrien mit Produkten
        $q = $this->createQuery();
        $q->statement(
            'SELECT uid_foreign,sum(1) AS anzahl from tx_igshop2_product_category_mm JOIN tx_igshop2_domain_model_product ON sys_language_uid IN(-1, ' . $languageAspect->getId() . ') AND (uid_local=tx_igshop2_domain_model_product.l10n_parent OR uid_local=tx_igshop2_domain_model_product.uid) WHERE ' . $sqlWhere . ' GROUP BY uid_foreign'
        );
        $qRes = $q->execute(true);

        // entspricht am schluss
        //SELECT tx_igshop2_domain_model_category.name,tx_igshop2_domain_model_category.uid,tx_igshop2_domain_model_category.parent,SUM(1) as anzahl from tx_igshop2_domain_model_category JOIN tx_igshop2_product_category_mm ON tx_igshop2_domain_model_category.uid=uid_foreign JOIN tx_igshop2_domain_model_product ON tx_igshop2_domain_model_product.uid=uid_local AND tx_igshop2_domain_model_product.deleted=0 AND tx_igshop2_domain_model_product.hidden=0 WHERE tx_igshop2_domain_model_product.pid=4205 AND tx_igshop2_domain_model_category.deleted=0 AND tx_igshop2_domain_model_category.hidden=0 AND  tx_igshop2_domain_model_product.mandant_uid=11683 GROUP BY  tx_igshop2_domain_model_category.name,tx_igshop2_domain_model_category.uid,tx_igshop2_domain_model_category.parent order by tx_igshop2_domain_model_category.name;


        $uids = [];
        foreach ($qRes as $row) {
            $uids[] = $row['uid_foreign'];
        }

        if (!empty($uids)) {
            $query->matching($query->logicalOr($query->in('uid', $uids), $query->in('l10n_parent', $uids)));
        }

        $query->setOrderings([
            'name' => QueryInterface::ORDER_ASCENDING,
        ]);
        return $query->execute();
    }

    public function findByParentAndProductsOrSubcategories($parent)
    {
        //$time_start = microtime(true);
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();
        //$querySettings->setLanguageOverlayMode(true);

        //$q->statement('SELECT DISTINCT uid_foreign from tx_igshop2_product_category_mm JOIN tx_igshop2_domain_model_product ON sys_language_uid=2 AND (uid_local=tx_igshop2_domain_model_product.l10n_parent OR uid_local=tx_igshop2_domain_model_product.uid) WHERE deleted=0 AND hidden=0 AND pid IN (' . implode(',', $querySettings->getStoragePageIds()) . ')');
        /** @var LanguageAspect */
        $languageAspect = $querySettings->getLanguageAspect();
        // Alle Kateogrien mit Produkten
        $q = $this->createQuery();
        $q->statement(
            'SELECT uid_foreign,sum(1) AS anzahl,min(uid) AS product_min_uid from tx_igshop2_product_category_mm JOIN tx_igshop2_domain_model_product ON sys_language_uid IN(-1, ' . $languageAspect->getId() . ') AND (uid_local=tx_igshop2_domain_model_product.l10n_parent OR uid_local=tx_igshop2_domain_model_product.uid) WHERE deleted=0 AND hidden=0 AND pid IN (' . implode(
                ',',
                $querySettings->getStoragePageIds()
            ) . ') GROUP BY uid_foreign'
        );
        $qRes = $q->execute(true);

        $uids = [];
        $anzahl = [];
        $product_min_uid = [];
        foreach ($qRes as $row) {
            $uids[] = $row['uid_foreign'];
            $anzahl[$row['uid_foreign']] = $row['anzahl'];
            $product_min_uid[$row['uid_foreign']] = $row['product_min_uid'];
        }

        // Alle Kategorien mit Unterkategorien
        $q->statement(
            'SELECT DISTINCT parent FROM tx_igshop2_domain_model_category WHERE parent<>0 AND deleted=0 AND hidden = 0'
        );
        $qRes = $q->execute(true);
        $catWithChildrenUids = [];
        foreach ($qRes as $row) {
            $catWithChildrenUids[] = $row['parent'];
        }

        if (!empty($uids)) {
            $query->matching(
                $query->logicalAnd(
                    $query->equals('parent', $parent),
                    $query->logicalOr(
                        $query->in('uid', $uids),
                        $query->in('uid', $catWithChildrenUids),
                        $query->in('l10n_parent', $uids),
                        $query->in('l10n_parent', $catWithChildrenUids)
                    )
                )
            );
        }

        $query->setOrderings([
            'name' => QueryInterface::ORDER_ASCENDING,
        ]);
        $ret = [];

        foreach ($query->execute(true) as $c) {
            $a = $anzahl[$c['uid']];
            $c['productsCount'] = $a;
            if ($a == 1) {
                $c['productLink'] = $product_min_uid[$c['uid']];
                //$c->setProductLink($product_min_uid[$c['uid']]);
            }

            $c['firstLetter'] = $c['name'][0];
            $ret[] = $c;
        }

        //echo('time='.  (microtime(true)-$time_start ));
        return $ret;

        /*
          foreach($query->execute() as $c) {
          $c->setProductsCount($anzahl[$c->getUid()]);
          if( $anzahl[$c->getUid()]==1) {
          $c->setProductLink($product_min_uid[$c->getUid()]);
          }
          $ret[]=$c;
          }
          return $ret;
        */
    }

    /**
     * Find by multiple uids using, seperated string. Found on blog.teamgeist-medien.de
     *
     * @param string $uidList String containing uids
     * @return Category Matching model records
     */
    public function findByUids($uidList)
    {
        $constraints = [];
        $query = $this->createQuery();

        foreach ($uidList as $uid) {
            $constraints[] = $query->equals('uid', $uid);
        }

        return $query->matching($query->logicalOr($constraints))
                     ->execute();
    }


    public function getCategories($uidList)
    {
        if (is_array($uidList) && $uidList !== [] && !empty($uidList[0])) {
            return $this->createTree($this->findByUids($uidList));
        }

        exit;
    }

    public function getChildren($categoryID)
    {
        $query = $this->createQuery();
        return $query->matching($query->logicalAnd($query->equals('parent', $categoryID)))->execute();
    }

    public function findAllWithProductsAsTree($mandantUid = null): array
    {
        $categories = $this->findAllWithProducts($mandantUid);

        // Build a tree structure
        $tree = $this->buildTree($categories->toArray());
        return $tree;
    }

    public function findAllAsTree(): array
    {
        $categories = $this->findAll();

        // Build a tree structure
        $tree = $this->buildTree($categories->toArray());
        return $tree;
    }

    public function buildTreeAddParents(array $categories): array
    {
        $categoriesWithParents = [];
        $uids = [];
        foreach ($categories as $category) {
            $uids[$category->getUid()] = $category->getUid();
        }

        foreach ($categories as $category) {
            $categoriesWithParents[] = $category;
            $parent = $category->getParent();
            if ($parent && !isset($uids[$parent->getUid()])) {
                $uids[$parent->getUid()] = $parent->getUid();
                $categoriesWithParents[] = $parent;
            }
        }

        usort($categoriesWithParents, static fn ($a, $b) => $a->getSorting() - $b->getSorting());
        return $this->buildTree($categoriesWithParents);
    }

    public function buildTree(array $categories, int $parentUid = 0): array
    {
        $tree = [];
        foreach ($categories as $category) {
            $categoryParentUid = $category->getParent() ? $category->getParent()
                                                                   ->getUid() : 0;

            if ($categoryParentUid == $parentUid) {
                //echo ($categoryParentUid . ' ('.$category->getName().', uid= '.$category->getUid().')<br />');
                $children = $this->buildTree($categories, $category->getUid());
                $tree[] = [
                    'uid' => $category->getUid(),
                    'name' => $category->getName(),
                    'object' => $category,
                    'children' => $children,
                ];
            }
        }

        return $tree;
    }

    public function getRootLine($startID)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('uid', $startID)];
        $query->matching($query->logicalOr($constraints));
        //$category = $query->execute()->toArray();
        return $query->execute()
                     ->toArray();
    }

    public function findByParentAndLetter($parent, $letter)
    {
        $query = $this->createQuery();

        $query->matching($query->logicalAnd(
            $query->equals('parent', $parent),
            $query->like('name', $letter . '%')
        ));

        return $query->execute();
    }

    public function findByUidBackend(int $uid)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
              ->setIgnoreEnableFields(true)
              ->setEnableFieldsToBeIgnored(['hidden'])
              ->setRespectStoragePage(false);
        $query->matching($query->equals('uid', (int) $uid));
        return $query->execute()
                     ->getFirst();
    }

    public function findByPidAndSearchRaw(int $pid, array $search = null)
    {
        $tableName = 'tx_igshop2_domain_model_category';
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($tableName);
        $queryBuilder->getRestrictions()
                     ->removeAll();
        $queryBuilder->getRestrictions()
                     ->add(GeneralUtility::makeInstance(DeletedRestriction::class));
        $queryBuilder->select('*')
                     ->from($tableName)
                     ->where($queryBuilder->expr()->eq('pid', $queryBuilder->createNamedParameter($pid, ParameterType::INTEGER)));
        if ($search !== null && isset($search['keywords']) && $search['keywords']) {
            $queryBuilder->andWhere(
                $queryBuilder->expr()
                             ->like(
                                 'name',
                                 $queryBuilder->createNamedParameter('%' . $queryBuilder->escapeLikeWildcards($search['keywords']) . '%')
                             )
            );
        }

        if ($search !== null && isset($search['category']) && $search['category'] != '') {
            $queryBuilder->andWhere(
                $queryBuilder->expr()
                             ->eq('parent', $queryBuilder->createNamedParameter($search['category'], ParameterType::INTEGER))
            );
        }

        $queryBuilder->orderBy('sorting', 'ASC');

        return $queryBuilder->executeQuery()
                            ->fetchAllAssociative();
        //return $query->execute(true);
    }

    /* Puralpina Mist*/
    public function getParentCategories()
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd($query->equals('parent', '')),
            $query->logicalAnd($query->equals('sys_language_uid', $context->getPropertyFromAspect('language', 'id')))
        );

        return $query->execute();
    }


    public function createTree($flat, $root = 0)
    {
        $parents = [];
        foreach ($flat as $a) {
            if (is_object($a->getParent())) {
                $parents[$a->getParent()->getUid()][] = [
                    'object' => $a,
                ];
            } else {
                $parents[0][] = [
                    'object' => $a,
                ];
            }
        }

        return $this->createBranch($parents, $parents[$root]);
    }


    public function createBranch(&$parents, $children, $isTop = true)
    {
        $tree = [];
        $first = true;
        foreach ($children as $child) {
            if ($first) {
                if (isset($parents[$child['object']->getUid()])) {
                    $child['ITEM_STATE'] = 'ACTIFSUB';
                    $child['pid'] = 2000;
                } else {
                    $child['ITEM_STATE'] = 'ACTIF';
                }

                $first = false;
            }

            $child['doktype'] = '4';
            $child['title'] = $child['object']->getName();
            $child['_OVERRIDE_HREF'] = 'index.php?id=22&igShop2[catNavUids]=' . $child['object']->getUid();
            if (isset($parents[$child['object']->getUid()])) {
                $child['_SUB_MENU'] = $this->createBranch($parents, $parents[$child['object']->getUid()], false);
            }

            unset($child['object']);
            $tree[] = $child;
        }

        return $tree;
    }

    public function findSortedByAlphabet()
    {
    }

    /* Puralpina Mist ende */
}
