<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use DateTime;
use Doctrine\DBAL\ParameterType;
use InternetGalerie\Igshop2\Domain\Model\Product;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

/**
 * The repository for Orders
 */
class OrderProductRepository extends Repository
{
    protected static $tablename = 'tx_igshop2_domain_model_orderproduct';
    protected static $orderTablename = 'tx_igshop2_domain_model_order';

    public function getReservedQuantityForProduct(Product $product, ?int $excludeCartId = null, ?int $excludeUserId = null): int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(static::$tablename);
         $expr = [
             $queryBuilder->expr()->eq('op.product', $queryBuilder->createNamedParameter($product->getUid(), ParameterType::INTEGER)),
             $queryBuilder->expr()->eq('o.reserved', $queryBuilder->createNamedParameter(1, ParameterType::INTEGER)),
             $queryBuilder->expr()->eq('o.submitted', $queryBuilder->createNamedParameter(0, ParameterType::INTEGER)),
             $queryBuilder->expr()->gte('o.reserved_until', $queryBuilder->createNamedParameter((new \DateTime())->format('Y-m-d H:i:s')))
         ];
        if ($excludeUserId > 0) {
            $expr[] = $queryBuilder->expr()->neq('o.userid', $queryBuilder->createNamedParameter($excludeUserId, ParameterType::INTEGER));
        }
        if ($excludeCartId > 0) {
            $expr[] = $queryBuilder->expr()->neq('o.cart', $queryBuilder->createNamedParameter($excludeCartId, ParameterType::INTEGER));
        }

        $sum = $queryBuilder
             ->selectLiteral('SUM(amount) as reserved')
             ->from(static::$tablename, 'op')
             ->join(
                 'op',
                 static::$orderTablename,
                 'o',
                 'o.uid = op.tx_order'
             )
             ->where(...$expr)
             ->executeQuery()
             ->fetchOne();
        return (int)$sum;
    }

}
