<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2017
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * The repository for Portoprices
 */
class PortopriceRepository extends Repository
{
    protected $defaultOrderings = [
        'price' => QueryInterface::ORDER_ASCENDING,
    ];


    /**
     * Returns the Portoprice
     *
     * @param float $amount
     * @param integer $quantity
     */
    public function findPrice($portoUid, $amount, $quantity)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('porto', $portoUid),
                $query->logicalOr(
                    $query->lessThanOrEqual('amount_min', $amount),
                    $query->equals('amount_min', null)
                ),
                $query->logicalOr(
                    $query->greaterThanOrEqual('amount_max', $amount),
                    $query->equals('amount_max', null)
                ),
                $query->logicalOr(
                    $query->lessThanOrEqual('quantity_min', $quantity),
                    $query->equals('quantity_min', null)
                ),
                $query->logicalOr(
                    $query->greaterThanOrEqual('quantity_max', $quantity),
                    $query->equals('quantity_max', null)
                )
            )
        );
        return $query->execute();
    }

    public function findCurrentPrice($portoUid, $amount, $quantity)
    {
        $res = $this->findPrice($portoUid, $amount, $quantity);
        //echo('<br />count='.$res->count());
        return $res->count() > 0 ? $res->getFirst() : null;
    }



    /**
     * Returns the Portoprice
     *
     * @param float $amount
     * @param integer $quantity
     */
    public function findAllPrice($portoUid, $amount, $quantity)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('porto', $portoUid),
                $query->logicalOr(
                    $query->greaterThanOrEqual('amount_min', $amount),
                    $query->equals('amount_min', null)
                ),
                $query->logicalOr(
                    $query->lessThanOrEqual('amount_max', $amount),
                    $query->equals('amount_max', null)
                ),
                $query->logicalOr(
                    $query->lessThanOrEqual('quantity_min', $quantity),
                    $query->equals('quantity_min', null)
                ),
                $query->logicalOr(
                    $query->greaterThanOrEqual('quantity_max', $quantity),
                    $query->equals('quantity_max', null)
                )
            )
        );
        return $query->execute();
    }



    public function findNextPrice($portoUid, $amount, $quantity)
    {
        $res = $this->findAllPrice($portoUid, $amount, $quantity);
        //echo('<br />count='.$res->count());
        return $res->count() > 0 ? $res->getFirst() : null;
    }
}
