<?php

namespace InternetGalerie\Igshop2\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use InternetGalerie\Igshop2\Domain\Model\FeUser;
use InternetGalerie\Igshop2\Domain\Model\ReminderList;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for ReminderLists
 */
class ReminderListRepository extends Repository
{
    public function getCurrentReminderList($reminderListUid = null, ?FeUser $feUser = null): ReminderList
    {
        $request = $GLOBALS['TYPO3_REQUEST'];
        $frontendUser = $request->getAttribute('frontend.user');
        $reminderList = null;

        if (!is_null($reminderListUid)) {
            $reminderList = $this->findByUid($reminderListUid);
        } else {
            $sessionReminderListUid = $frontendUser ? intval($frontendUser->getKey('ses', 'shopReminderList')) : 0;
            if ($sessionReminderListUid) {
                $reminderList = $this->findByUid($sessionReminderListUid);
            }

            if (!$reminderList) {
                $reminderList = GeneralUtility::makeInstance(ReminderList::class);
            }
        }

        $context = GeneralUtility::makeInstance(Context::class);
        //enshures: order is saved to db and session.shopCart=order.uid

        // TODO: int brauchen für User?
        if ($feUser !== null) {
            $reminderList->setUser($feUser);
        } else {
            $reminderList->setUser(null);
        }

        if ($reminderList->_isNew()) {
            $this->add($reminderList);
        } else {
            $this->update($reminderList);
        }
        
        $this->persistenceManager->persistAll();

        if ($frontendUser) {
            $frontendUser->setKey('ses', 'shopReminderList', $reminderList->getUid());
            $frontendUser->storeSessionData();
        }

        return $reminderList;
    }
}
